/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ExtendedActorSystem;
import akka.serialization.JavaSerializer;
import akka.serialization.Serialization;
import java.io.DataInput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.opendaylight.controller.cluster.access.commands.ConnectClientSuccess;
import org.opendaylight.controller.cluster.access.concepts.AbstractSuccessProxy;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;

final class ConnectClientSuccessProxyV1
extends AbstractSuccessProxy<ClientIdentifier, ConnectClientSuccess> {
    private static final long serialVersionUID = 1L;
    private List<ActorSelection> alternates;
    private ActorRef backend;
    private int maxMessages;

    public ConnectClientSuccessProxyV1() {
    }

    ConnectClientSuccessProxyV1(ConnectClientSuccess success) {
        super(success);
        this.alternates = success.getAlternates();
        this.backend = success.getBackend();
        this.maxMessages = success.getMaxMessages();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(Serialization.serializedActorPath((ActorRef)this.backend));
        out.writeInt(this.maxMessages);
        out.writeInt(this.alternates.size());
        for (ActorSelection b : this.alternates) {
            out.writeObject(b.toSerializationFormat());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.backend = ((ExtendedActorSystem)JavaSerializer.currentSystem().value()).provider().resolveActorRef((String)in.readObject());
        this.maxMessages = in.readInt();
        int alternatesSize = in.readInt();
        this.alternates = new ArrayList<ActorSelection>(alternatesSize);
        for (int i = 0; i < alternatesSize; ++i) {
            this.alternates.add(ActorSelection.apply((ActorRef)ActorRef.noSender(), (String)((String)in.readObject())));
        }
    }

    @Override
    protected ConnectClientSuccess createSuccess(ClientIdentifier target, long sequence) {
        return new ConnectClientSuccess(target, sequence, this.backend, this.alternates, Optional.empty(), this.maxMessages);
    }

    @Override
    protected ClientIdentifier readTarget(DataInput in) throws IOException {
        return ClientIdentifier.readFrom(in);
    }
}

