/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.AbstractReadTransactionRequestProxyV1;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;

@Beta
public abstract class AbstractReadTransactionRequest<T extends AbstractReadTransactionRequest<T>>
extends TransactionRequest<T> {
    private static final long serialVersionUID = 1L;
    private final boolean snapshotOnly;

    AbstractReadTransactionRequest(TransactionIdentifier identifier, long sequence, ActorRef replyTo, boolean snapshotOnly) {
        super(identifier, sequence, replyTo);
        this.snapshotOnly = snapshotOnly;
    }

    AbstractReadTransactionRequest(T request, ABIVersion version) {
        super(request, version);
        this.snapshotOnly = ((AbstractReadTransactionRequest)request).isSnapshotOnly();
    }

    public final boolean isSnapshotOnly() {
        return this.snapshotOnly;
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("snapshotOnly", this.snapshotOnly);
    }

    @Override
    protected abstract AbstractReadTransactionRequestProxyV1<T> externalizableProxy(ABIVersion var1);
}

