/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.eclipselink.adapter;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnionClassLoader
extends ClassLoader
implements BundleReference {
    private static final String ORG_OSGI_FRAMEWORK = "org.osgi.framework.";
    private static final int DOT_INDEX = "org.osgi.framework.".lastIndexOf(46);
    private static final Logger LOG = LoggerFactory.getLogger(UnionClassLoader.class);
    private final Bundle eclipseLinkBundle;
    private final Bundle adaptorBundle;
    private final Map<String, Class<?>> registeredPlugins = new HashMap();

    public UnionClassLoader(ClassLoader parentLoader, Bundle b, Bundle adaptor, Map<String, Object> arg1) {
        super(parentLoader);
        Object o;
        this.eclipseLinkBundle = b;
        this.adaptorBundle = adaptor;
        Object object = o = arg1 == null ? null : arg1.get("org.apache.aries.jpa.eclipselink.plugin.types");
        if (o instanceof Class) {
            Class c = (Class)o;
            this.registeredPlugins.put(c.getName(), c);
        } else if (o instanceof Collection) {
            for (Object o2 : (Collection)o) {
                Class c = (Class)o2;
                this.registeredPlugins.put(c.getName(), c);
            }
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.registeredPlugins.containsKey(name)) {
            return this.registeredPlugins.get(name);
        }
        if ("org.apache.aries.jpa.eclipselink.adapter.platform.OSGiTSServer".equals(name) || "org.apache.aries.jpa.eclipselink.adapter.platform.OSGiTSWrapper".equals(name)) {
            return this.loadTempClass(name);
        }
        if (name.startsWith(ORG_OSGI_FRAMEWORK) && name.lastIndexOf(46) == DOT_INDEX) {
            return this.adaptorBundle.loadClass(name);
        }
        return this.eclipseLinkBundle.loadClass(name);
    }

    private Class<?> loadTempClass(String name) throws ClassNotFoundException, ClassFormatError {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(name.replace('.', '/') + ".class");
        if (is == null) {
            throw new ClassNotFoundException(name);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            UnionClassLoader.copy(is, baos);
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(name, ioe);
        }
        return this.defineClass(name, baos.toByteArray(), 0, baos.size());
    }

    public Bundle getBundle() {
        return this.adaptorBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(InputStream in, OutputStream out) throws IOException {
        try {
            int len;
            byte[] b = new byte[1024];
            while ((len = in.read(b)) != -1) {
                out.write(b, 0, len);
            }
        }
        finally {
            UnionClassLoader.close(in);
        }
    }

    private static void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException e) {
            LOG.debug("Exception closing", (Throwable)e);
        }
    }
}

