/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.spi.scan;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Model;
import javax.enterprise.inject.Stereotype;
import javax.interceptor.Interceptor;
import org.apache.xbean.finder.AnnotationFinder;
import org.ops4j.pax.cdi.api.BundleScoped;
import org.ops4j.pax.cdi.api.Component;
import org.ops4j.pax.cdi.api.PrototypeScoped;
import org.ops4j.pax.cdi.api.Service;
import org.ops4j.pax.cdi.api.SingletonScoped;
import org.ops4j.pax.cdi.spi.scan.BeanAnnotationFinder;
import org.ops4j.pax.cdi.spi.scan.BeanBundleFilter;
import org.ops4j.pax.cdi.spi.scan.BeanDescriptor;
import org.ops4j.pax.cdi.spi.scan.BeanDescriptorParser;
import org.ops4j.pax.cdi.spi.scan.BeanDiscoveryMode;
import org.ops4j.pax.cdi.spi.scan.BundleArchive;
import org.osgi.framework.Bundle;

public class BeanScanner {
    private static Set<String> beanDefiningAnnotations = new HashSet<String>();
    private BeanBundleFilter filter;
    private BundleArchive archive;
    private Set<String> beanClasses = new HashSet<String>();
    private BeanAnnotationFinder finder;

    public BeanScanner(Bundle bundle, BeanDescriptorParser parser) {
        this.filter = new BeanBundleFilter(parser);
        this.archive = new BundleArchive(bundle, this.filter);
    }

    public Set<String> getBeanClasses() {
        return Collections.unmodifiableSet(this.beanClasses);
    }

    public Set<URL> getBeanDescriptors() {
        HashSet<URL> urls = new HashSet<URL>(this.filter.getBeanDescriptors());
        return Collections.unmodifiableSet(urls);
    }

    public void scan() {
        this.finder = new BeanAnnotationFinder(this.archive);
        for (String className : this.finder.getAnnotatedClassNames()) {
            if (!this.isBeanClass(className)) continue;
            this.beanClasses.add(className);
        }
    }

    private boolean isBeanClass(String className) {
        Bundle provider = this.archive.getProvider(className);
        BeanDescriptor descriptor = this.filter.findDescriptor(provider);
        if (descriptor.getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.ANNOTATED)) {
            AnnotationFinder.ClassInfo classInfo = this.finder.getClassInfo(className);
            return this.isBeanAnnotatedClass(classInfo);
        }
        return true;
    }

    protected boolean isBeanAnnotatedClass(AnnotationFinder.ClassInfo classInfo) {
        for (AnnotationFinder.AnnotationInfo annotationInfo : classInfo.getAnnotations()) {
            if (!this.isBeanAnnotation(annotationInfo)) continue;
            return true;
        }
        return false;
    }

    private boolean isBeanAnnotation(AnnotationFinder.AnnotationInfo annotationInfo) {
        return beanDefiningAnnotations.contains(annotationInfo.getName());
    }

    static {
        for (Class klass : Arrays.asList(Dependent.class, RequestScoped.class, ConversationScoped.class, SessionScoped.class, ApplicationScoped.class, Interceptor.class, Decorator.class, Model.class, NormalScope.class, Stereotype.class, BundleScoped.class, PrototypeScoped.class, SingletonScoped.class, Component.class, Service.class)) {
            beanDefiningAnnotations.add(klass.getName());
        }
    }
}

