/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.spi;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.WeakHashMap;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import org.ops4j.pax.cdi.spi.CdiContainer;
import org.ops4j.pax.cdi.spi.InjectionTargetWrapper;

public class Injector {
    private BeanManager beanManager;
    private Map<Class<?>, InjectionTarget<?>> injectionTargets = new WeakHashMap();
    private CdiContainer cdiContainer;

    public Injector(CdiContainer cdiContainer) {
        this.cdiContainer = cdiContainer;
        this.beanManager = cdiContainer.getBeanManager();
    }

    public <T> void inject(T target) {
        Class<?> klass = target.getClass();
        InjectionTarget<?> it = this.getInjectionTarget(klass);
        CreationalContext context = this.beanManager.createCreationalContext(null);
        it.inject(target, context);
        it.postConstruct(target);
    }

    private <T> InjectionTarget<T> getInjectionTarget(Class<T> klass) {
        Object it = this.injectionTargets.get(klass);
        if (it == null) {
            it = this.createInjectionTarget(klass);
            this.injectionTargets.put(klass, (InjectionTarget<?>)it);
        }
        return it;
    }

    private <T> InjectionTarget<T> createInjectionTarget(Class<T> klass) {
        AnnotatedType type = this.beanManager.createAnnotatedType(klass);
        InjectionTargetFactory itFactory = this.beanManager.getInjectionTargetFactory(type);
        InjectionTarget it = itFactory.createInjectionTarget(null);
        return it;
    }

    private <T> InjectionTargetWrapper<T> getWrapper(Class<T> klass) {
        return (InjectionTargetWrapper)this.cdiContainer.getInstance().select(InjectionTargetWrapper.class, new Annotation[0]).get();
    }

    public <T> void destroy(T instance) {
        if (instance != null) {
            Class<?> klass = instance.getClass();
            InjectionTarget<?> it = this.getInjectionTarget(klass);
            it.preDestroy(instance);
            it.dispose(instance);
        }
    }
}

