/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.spi;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.Callable;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.xbean.osgi.bundle.util.BundleClassLoader;
import org.apache.xbean.osgi.bundle.util.DelegatingBundle;
import org.ops4j.pax.cdi.spi.BeanBundles;
import org.ops4j.pax.cdi.spi.CdiClassLoaderBuilder;
import org.ops4j.pax.cdi.spi.CdiClassLoaderBuilderCustomizer;
import org.ops4j.pax.cdi.spi.CdiContainer;
import org.ops4j.pax.cdi.spi.ContainerInitialized;
import org.ops4j.pax.cdi.spi.util.Exceptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCdiContainer
implements CdiContainer,
CdiClassLoaderBuilderCustomizer {
    private static Logger log = LoggerFactory.getLogger(AbstractCdiContainer.class);
    private Bundle bundle;
    private ServiceRegistration<CdiContainer> cdiContainerReg;
    private ServiceRegistration<BeanManager> beanManagerReg;
    private boolean started;
    private Collection<Bundle> extensionBundles;
    private Collection<Bundle> additionalBundles;
    private ClassLoader contextClassLoader;
    private CdiClassLoaderBuilder builder;

    protected AbstractCdiContainer(Bundle bundle, Collection<Bundle> extensionBundles, Collection<Bundle> additionalBundles) {
        this.bundle = bundle;
        this.extensionBundles = extensionBundles;
        this.additionalBundles = additionalBundles;
    }

    @Override
    public synchronized void start(Object environment) {
        if (!this.started) {
            log.info("Starting CDI container for bundle {}", (Object)this.getBundle());
            this.contextClassLoader = this.buildContextClassLoader(environment);
            BeanBundles.addBundle(this.getContextClassLoader(), this.getBundle());
            this.doStart(environment);
            this.finishStartup();
            this.started = true;
        }
    }

    @Override
    public synchronized void stop() {
        if (this.started) {
            log.info("Stopping CDI container for bundle {}", (Object)this.getBundle());
            this.doStop();
            BeanBundles.removeBundle(this.getContextClassLoader(), this.getBundle());
            this.unregister(this.cdiContainerReg);
            this.unregister(this.beanManagerReg);
            this.started = false;
        }
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    private <S> void unregister(ServiceRegistration<S> registration) {
        if (registration != null) {
            try {
                registration.unregister();
            }
            catch (IllegalStateException exc) {
                log.trace("service already unregistered", (Throwable)exc);
            }
        }
    }

    protected abstract void doStart(Object var1);

    protected abstract void doStop();

    protected ClassLoader buildContextClassLoader(Object environment) {
        ClassLoader cl;
        ArrayList<Bundle> delegateBundles = new ArrayList<Bundle>();
        delegateBundles.add(this.bundle);
        delegateBundles.addAll(this.additionalBundles);
        delegateBundles.addAll(this.extensionBundles);
        if (this.builder != null && (cl = this.builder.buildContextClassLoader(environment, this.bundle, this.extensionBundles, this.additionalBundles)) != null) {
            log.info("Using provided contextClassLoader: {}", (Object)cl);
            return cl;
        }
        DelegatingBundle delegatingBundle = new DelegatingBundle(delegateBundles);
        BundleClassLoader classLoader = new BundleClassLoader((Bundle)delegatingBundle);
        log.info("Using default contextClassLoader: {}", (Object)classLoader);
        return classLoader;
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V doWithClassLoader(Callable<V> callable) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader prevTccl = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(this.getContextClassLoader());
            V v = callable.call();
            return v;
        }
        finally {
            currentThread.setContextClassLoader(prevTccl);
        }
    }

    private void finishStartup() {
        try {
            this.cdiContainerReg = this.doWithClassLoader(new Callable<ServiceRegistration<CdiContainer>>(){

                @Override
                public ServiceRegistration<CdiContainer> call() throws Exception {
                    return AbstractCdiContainer.this.registerCdiContainer();
                }
            });
        }
        catch (Exception exc) {
            log.error("", (Throwable)exc);
            throw Exceptions.unchecked(exc);
        }
    }

    private ServiceRegistration<CdiContainer> registerCdiContainer() {
        BundleContext bc = this.bundle.getBundleContext();
        BeanManager beanManager = this.getBeanManager();
        beanManager.fireEvent((Object)new ContainerInitialized(), new Annotation[0]);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("bundleId", this.bundle.getBundleId());
        ((Dictionary)props).put("symbolicName", this.bundle.getSymbolicName());
        ServiceRegistration reg = bc.registerService(CdiContainer.class, (Object)this, props);
        this.beanManagerReg = bc.registerService(BeanManager.class, (Object)this.getBeanManager(), props);
        return reg;
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public void setCdiClassLoaderBuilder(CdiClassLoaderBuilder builder) {
        this.builder = builder;
    }
}

