/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestStatus;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TestStatusBuilder
implements Builder<TestStatus> {
    private TestStatus.ExecStatus _execStatus;
    private Long _testsCompleted;
    Map<Class<? extends Augmentation<TestStatus>>, Augmentation<TestStatus>> augmentation = Collections.emptyMap();

    public TestStatusBuilder() {
    }

    public TestStatusBuilder(TestStatus base) {
        Map aug;
        this._execStatus = base.getExecStatus();
        this._testsCompleted = base.getTestsCompleted();
        if (base instanceof TestStatusImpl) {
            TestStatusImpl impl = (TestStatusImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TestStatus>>, Augmentation<TestStatus>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TestStatus>>, Augmentation<TestStatus>>(aug);
        }
    }

    public TestStatus.ExecStatus getExecStatus() {
        return this._execStatus;
    }

    public Long getTestsCompleted() {
        return this._testsCompleted;
    }

    public <E$$ extends Augmentation<TestStatus>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public TestStatusBuilder setExecStatus(TestStatus.ExecStatus value) {
        this._execStatus = value;
        return this;
    }

    private static void checkTestsCompletedRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public TestStatusBuilder setTestsCompleted(Long value) {
        if (value != null) {
            TestStatusBuilder.checkTestsCompletedRange(value);
        }
        this._testsCompleted = value;
        return this;
    }

    public TestStatusBuilder addAugmentation(Class<? extends Augmentation<TestStatus>> augmentationType, Augmentation<TestStatus> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TestStatus>>, Augmentation<TestStatus>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TestStatusBuilder removeAugmentation(Class<? extends Augmentation<TestStatus>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TestStatus build() {
        return new TestStatusImpl(this);
    }

    private static final class TestStatusImpl
    implements TestStatus {
        private final TestStatus.ExecStatus _execStatus;
        private final Long _testsCompleted;
        private Map<Class<? extends Augmentation<TestStatus>>, Augmentation<TestStatus>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        TestStatusImpl(TestStatusBuilder base) {
            this._execStatus = base.getExecStatus();
            this._testsCompleted = base.getTestsCompleted();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<TestStatus> getImplementedInterface() {
            return TestStatus.class;
        }

        @Override
        public TestStatus.ExecStatus getExecStatus() {
            return this._execStatus;
        }

        @Override
        public Long getTestsCompleted() {
            return this._testsCompleted;
        }

        public <E$$ extends Augmentation<TestStatus>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._execStatus);
            result = 31 * result + Objects.hashCode(this._testsCompleted);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TestStatus.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TestStatus other = (TestStatus)obj;
            if (!Objects.equals((Object)this._execStatus, (Object)other.getExecStatus())) {
                return false;
            }
            if (!Objects.equals(this._testsCompleted, other.getTestsCompleted())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TestStatusImpl otherImpl = (TestStatusImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TestStatus>>, Augmentation<TestStatus>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"TestStatus");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_execStatus", (Object)((Object)this._execStatus));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_testsCompleted", (Object)this._testsCompleted);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

