/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.ssh;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.netty.channel.EventLoopGroup;
import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.io.nio2.Nio2Acceptor;
import org.apache.sshd.common.io.nio2.Nio2Connector;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactoryFactory;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.server.SshServer;
import org.opendaylight.netconf.ssh.RemoteNetconfCommand;
import org.opendaylight.netconf.ssh.SshProxyServerConfiguration;

public class SshProxyServer
implements AutoCloseable {
    private final SshServer sshServer;
    private final ScheduledExecutorService minaTimerExecutor;
    private final EventLoopGroup clientGroup;
    private final IoServiceFactoryFactory nioServiceWithPoolFactoryFactory;

    private SshProxyServer(ScheduledExecutorService minaTimerExecutor, EventLoopGroup clientGroup, IoServiceFactoryFactory serviceFactory) {
        this.minaTimerExecutor = minaTimerExecutor;
        this.clientGroup = clientGroup;
        this.nioServiceWithPoolFactoryFactory = serviceFactory;
        this.sshServer = SshServer.setUpDefaultServer();
    }

    public SshProxyServer(ScheduledExecutorService minaTimerExecutor, EventLoopGroup clientGroup, ExecutorService nioExecutor) {
        this(minaTimerExecutor, clientGroup, (IoServiceFactoryFactory)new NioServiceWithPoolFactoryFactory(nioExecutor));
    }

    @VisibleForTesting
    public SshProxyServer(ScheduledExecutorService minaTimerExecutor, EventLoopGroup clientGroup, AsynchronousChannelGroup group) {
        this(minaTimerExecutor, clientGroup, (IoServiceFactoryFactory)new SharedNioServiceFactoryFactory(group));
    }

    public void bind(SshProxyServerConfiguration sshProxyServerConfiguration) throws IOException {
        this.sshServer.setHost(sshProxyServerConfiguration.getBindingAddress().getHostString());
        this.sshServer.setPort(sshProxyServerConfiguration.getBindingAddress().getPort());
        List cipherFactories = this.sshServer.getCipherFactories();
        cipherFactories.removeIf(factory -> factory.getName().contains(BuiltinCiphers.arcfour128.getName()) || factory.getName().contains(BuiltinCiphers.arcfour256.getName()));
        this.sshServer.setPasswordAuthenticator((username, password, session) -> sshProxyServerConfiguration.getAuthenticator().authenticated(username, password));
        sshProxyServerConfiguration.getPublickeyAuthenticator().ifPresent(arg_0 -> ((SshServer)this.sshServer).setPublickeyAuthenticator(arg_0));
        this.sshServer.setKeyPairProvider(sshProxyServerConfiguration.getKeyPairProvider());
        this.sshServer.setIoServiceFactoryFactory(this.nioServiceWithPoolFactoryFactory);
        this.sshServer.setScheduledExecutorService(this.minaTimerExecutor);
        this.sshServer.getProperties().put("idle-timeout", String.valueOf(sshProxyServerConfiguration.getIdleTimeout()));
        this.sshServer.getProperties().put("auth-timeout", String.valueOf(sshProxyServerConfiguration.getIdleTimeout()));
        RemoteNetconfCommand.NetconfCommandFactory netconfCommandFactory = new RemoteNetconfCommand.NetconfCommandFactory(this.clientGroup, sshProxyServerConfiguration.getLocalAddress());
        this.sshServer.setSubsystemFactories((List)ImmutableList.of((Object)netconfCommandFactory));
        this.sshServer.start();
    }

    @Override
    public void close() throws IOException {
        try {
            this.sshServer.stop(true);
        }
        finally {
            this.sshServer.close(true);
        }
    }

    private static final class SharedNioServiceFactoryFactory
    extends Nio2ServiceFactoryFactory {
        private final AsynchronousChannelGroup group;

        SharedNioServiceFactoryFactory(AsynchronousChannelGroup group) {
            this.group = Objects.requireNonNull(group);
        }

        public IoServiceFactory create(FactoryManager manager) {
            return new SharedNioServiceFactory(manager, this.group);
        }
    }

    private static final class SharedNioServiceFactory
    extends AbstractNioServiceFactory {
        SharedNioServiceFactory(FactoryManager manager, AsynchronousChannelGroup group) {
            super(manager, group);
        }
    }

    private static final class NioServiceWithPoolFactoryFactory
    extends Nio2ServiceFactoryFactory {
        private final ExecutorService nioExecutor;

        NioServiceWithPoolFactoryFactory(ExecutorService nioExecutor) {
            this.nioExecutor = nioExecutor;
        }

        public IoServiceFactory create(FactoryManager manager) {
            try {
                return new NioServiceWithPoolFactory(manager, AsynchronousChannelGroup.withThreadPool(this.nioExecutor));
            }
            catch (IOException e) {
                throw new RuntimeSshException("Failed to create channel group", (Throwable)e);
            }
        }
    }

    private static final class NioServiceWithPoolFactory
    extends AbstractNioServiceFactory {
        NioServiceWithPoolFactory(FactoryManager manager, AsynchronousChannelGroup group) {
            super(manager, group);
        }

        protected void doCloseImmediately() {
            try {
                this.group().shutdownNow();
                this.group().awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                this.log.debug("Exception caught while closing channel group", (Throwable)e);
            }
            finally {
                super.doCloseImmediately();
            }
        }
    }

    private static abstract class AbstractNioServiceFactory
    extends AbstractCloseable
    implements IoServiceFactory {
        private final FactoryManager manager;
        private final AsynchronousChannelGroup group;
        private IoServiceEventListener eventListener;

        AbstractNioServiceFactory(FactoryManager manager, AsynchronousChannelGroup group) {
            this.manager = Objects.requireNonNull(manager);
            this.group = Objects.requireNonNull(group);
        }

        final AsynchronousChannelGroup group() {
            return this.group;
        }

        public final IoConnector createConnector(IoHandler handler) {
            return new Nio2Connector(this.manager, handler, this.group);
        }

        public final IoAcceptor createAcceptor(IoHandler handler) {
            return new Nio2Acceptor(this.manager, handler, this.group);
        }

        public final IoServiceEventListener getIoServiceEventListener() {
            return this.eventListener;
        }

        public final void setIoServiceEventListener(IoServiceEventListener listener) {
            this.eventListener = listener;
        }
    }
}

