/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.ssh;

import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.util.concurrent.EventExecutor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.opendaylight.netconf.api.NetconfServerDispatcher;
import org.opendaylight.netconf.auth.AuthProvider;
import org.opendaylight.netconf.ssh.SshProxyServer;
import org.opendaylight.netconf.ssh.SshProxyServerConfigurationBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IetfInetUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressBuilder;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfNorthboundSshServer {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfNorthboundSshServer.class);
    private static final String DEFAULT_PRIVATE_KEY_PATH = null;
    private static final String DEFAULT_ALGORITHM = "RSA";
    private static final int DEFAULT_KEY_SIZE = 4096;
    private final ChannelFuture localServer;
    private final SshProxyServer sshProxyServer;

    public NetconfNorthboundSshServer(NetconfServerDispatcher netconfServerDispatcher, EventLoopGroup workerGroup, EventExecutor eventExecutor, String bindingAddress, String portNumber, AuthProvider authProvider) {
        LocalAddress localAddress = new LocalAddress(portNumber);
        this.localServer = netconfServerDispatcher.createLocalServer(localAddress);
        this.sshProxyServer = new SshProxyServer(Executors.newScheduledThreadPool(1), workerGroup, (ExecutorService)eventExecutor);
        InetSocketAddress inetAddress = NetconfNorthboundSshServer.getInetAddress(bindingAddress, portNumber);
        SshProxyServerConfigurationBuilder sshProxyServerConfigurationBuilder = new SshProxyServerConfigurationBuilder();
        sshProxyServerConfigurationBuilder.setBindingAddress(inetAddress);
        sshProxyServerConfigurationBuilder.setLocalAddress(localAddress);
        sshProxyServerConfigurationBuilder.setAuthenticator(authProvider);
        sshProxyServerConfigurationBuilder.setIdleTimeout(Integer.MAX_VALUE);
        sshProxyServerConfigurationBuilder.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider());
        this.localServer.addListener(future -> {
            if (future.isDone() && !future.isCancelled()) {
                try {
                    this.sshProxyServer.bind(sshProxyServerConfigurationBuilder.createSshProxyServerConfiguration());
                    LOG.info("Netconf SSH endpoint started successfully at {}", (Object)bindingAddress);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to start SSH netconf server", e);
                }
            } else {
                LOG.warn("Unable to start SSH netconf server at {}", (Object)bindingAddress, (Object)future.cause());
                throw new RuntimeException("Unable to start SSH netconf server", future.cause());
            }
        });
    }

    private static InetSocketAddress getInetAddress(String bindingAddress, String portNumber) {
        IpAddress ipAddress = IpAddressBuilder.getDefaultInstance((String)bindingAddress);
        InetAddress inetAd = IetfInetUtil.INSTANCE.inetAddressFor((Object)ipAddress);
        return new InetSocketAddress(inetAd, Integer.parseInt(portNumber));
    }

    public void close() throws IOException {
        this.sshProxyServer.close();
        if (this.localServer.isDone()) {
            this.localServer.channel().close();
        } else {
            this.localServer.cancel(true);
        }
    }

    public void unbind(ServiceReference<?> reference) {
        LOG.debug("EventExecutor is being removed, closing netconf ssh server. {}", reference);
        try {
            this.close();
        }
        catch (IOException e) {
            LOG.error("Closing of ssh server failed while unbinding reference listener.", (Throwable)e);
        }
    }
}

