/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.audit.util;

import java.io.IOException;
import java.io.Writer;
import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.karaf.audit.util.NumberOutput;
import org.apache.karaf.jaas.boot.principal.ClientPrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;

public final class Buffer
implements Appendable,
CharSequence {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected final Format format;
    protected final int capacity;
    protected char[] buffer;
    protected int position = 0;

    public Buffer(Format format) {
        this(format, 1024);
    }

    public Buffer(Format format, int size) {
        this.format = format;
        this.capacity = size;
        this.buffer = new char[size];
    }

    public char[] buffer() {
        return this.buffer;
    }

    public int position() {
        return this.position;
    }

    public void clear() {
        this.position = 0;
        if (this.buffer.length > this.capacity) {
            this.buffer = new char[this.capacity];
        }
    }

    @Override
    public String toString() {
        return new String(this.buffer, 0, this.position);
    }

    public void writeTo(Appendable out) throws IOException {
        if (out instanceof Writer) {
            ((Writer)out).write(this.buffer, 0, this.position);
        } else if (out instanceof StringBuilder) {
            ((StringBuilder)out).append(this.buffer, 0, this.position);
        } else {
            out.append(this);
        }
    }

    private final void require(int nb) {
        if (this.position + nb >= this.buffer.length) {
            char[] b = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, b, 0, this.position);
            this.buffer = b;
        }
    }

    @Override
    public Buffer append(CharSequence csq) throws IOException {
        return this.append(csq, 0, csq.length());
    }

    @Override
    public Buffer append(CharSequence csq, int start, int end) throws IOException {
        if (csq instanceof String) {
            return this.append((String)csq, start, end);
        }
        this.require(end - start);
        for (int i = start; i < end; ++i) {
            this.buffer[this.position++] = csq.charAt(i);
        }
        return this;
    }

    public Buffer append(String str) throws IOException {
        return this.append(str, 0, str.length());
    }

    public Buffer append(String str, int start, int end) throws IOException {
        int nb = end - start;
        this.require(nb);
        str.getChars(start, end, this.buffer, this.position);
        this.position += nb;
        return this;
    }

    @Override
    public Buffer append(char c) throws IOException {
        this.require(1);
        this.buffer[this.position++] = c;
        return this;
    }

    @Override
    public int length() {
        return this.position;
    }

    @Override
    public char charAt(int index) {
        return this.buffer[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new String(this.buffer, start, end);
    }

    public Buffer format(Object object) throws IOException {
        if (object == null) {
            this.require(4);
            this.buffer[this.position++] = 110;
            this.buffer[this.position++] = 117;
            this.buffer[this.position++] = 108;
            this.buffer[this.position++] = 108;
            return this;
        }
        if (object.getClass().isArray()) {
            return this.format((Object[])object);
        }
        if (object instanceof Subject) {
            return this.format((Subject)object);
        }
        return this.format(object.toString());
    }

    public Buffer format(Object[] array) throws IOException {
        this.require(array.length * 10);
        this.buffer[this.position++] = 91;
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                this.buffer[this.position++] = 44;
                this.buffer[this.position++] = 32;
            }
            this.format(array[i]);
        }
        if (this.format == Format.Syslog) {
            this.buffer[this.position++] = 92;
        }
        this.buffer[this.position++] = 93;
        return this;
    }

    public Buffer format(Subject subject) throws IOException {
        String up = null;
        String cp = null;
        for (Principal p : subject.getPrincipals()) {
            if (p instanceof UserPrincipal) {
                up = p.getName();
                continue;
            }
            if (!(p instanceof ClientPrincipal)) continue;
            cp = p.getName();
        }
        if (up != null) {
            this.append(up);
        } else {
            this.append('?');
        }
        if (cp != null) {
            this.append('@');
            this.append(cp);
        }
        return this;
    }

    public Buffer format(String cs) throws IOException {
        switch (this.format) {
            case Json: {
                this.formatJson(cs);
                break;
            }
            case Syslog: {
                this.formatSyslog(cs);
            }
        }
        return this;
    }

    public Buffer format(int i) throws IOException {
        this.require(11);
        this.position = NumberOutput.outputInt(i, this.buffer, this.position);
        return this;
    }

    public Buffer format(long i) throws IOException {
        this.require(20);
        this.position = NumberOutput.outputLong(i, this.buffer, this.position);
        return this;
    }

    private void formatJson(String value) throws IOException {
        int len = value.length();
        this.require(len * 4);
        this.position = this.transferJson(this.position, this.buffer, value, 0, len);
    }

    private void formatSyslog(String value) throws IOException {
        int end = value.length();
        int max = Math.min(end, 255);
        this.require(max * 4);
        this.position = this.transferSyslog(this.position, this.buffer, value, 0, max);
        if (end > max) {
            this.require(3);
            this.buffer[this.position++] = 46;
            this.buffer[this.position++] = 46;
            this.buffer[this.position++] = 46;
        }
    }

    private int transferJson(int position, char[] d, String s, int start, int end) {
        block9: for (int i = start; i < end; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    d[position++] = 92;
                    d[position++] = 34;
                    continue block9;
                }
                case '\\': {
                    d[position++] = 92;
                    d[position++] = 92;
                    continue block9;
                }
                case '\b': {
                    d[position++] = 92;
                    d[position++] = 98;
                    continue block9;
                }
                case '\f': {
                    d[position++] = 92;
                    d[position++] = 102;
                    continue block9;
                }
                case '\n': {
                    d[position++] = 92;
                    d[position++] = 110;
                    continue block9;
                }
                case '\r': {
                    d[position++] = 92;
                    d[position++] = 114;
                    continue block9;
                }
                case '\t': {
                    d[position++] = 92;
                    d[position++] = 116;
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        d[position++] = 92;
                        d[position++] = 117;
                        d[position++] = HEX_DIGITS[c >> 12];
                        d[position++] = HEX_DIGITS[c >> 8 & 0xF];
                        d[position++] = HEX_DIGITS[c >> 4 & 0xF];
                        d[position++] = HEX_DIGITS[c & 0xF];
                        continue block9;
                    }
                    d[position++] = c;
                }
            }
        }
        return position;
    }

    private int transferSyslog(int position, char[] d, String s, int start, int end) {
        block3: for (int i = start; i < end; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': 
                case ']': {
                    d[position++] = 92;
                    d[position++] = c;
                    continue block3;
                }
                default: {
                    d[position++] = c;
                }
            }
        }
        return position;
    }

    public static enum Format {
        Json,
        Syslog;

    }
}

