/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.audit.layout;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.CharBuffer;
import java.util.Enumeration;
import org.apache.karaf.audit.Event;
import org.apache.karaf.audit.EventLayout;
import org.apache.karaf.audit.util.Buffer;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceEvent;

public abstract class AbstractLayout
implements EventLayout {
    protected final String hostName = AbstractLayout.hostname();
    protected final String appName = System.getProperty("karaf.name", "-");
    protected final String procId = AbstractLayout.procId();
    protected final Buffer buffer;

    public AbstractLayout(Buffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void format(Event event, Appendable to) throws IOException {
        this.doFormat(event);
        this.buffer.writeTo(to);
    }

    @Override
    public CharBuffer format(Event event) throws IOException {
        this.doFormat(event);
        return CharBuffer.wrap(this.buffer.buffer(), 0, this.buffer.position());
    }

    private void doFormat(Event event) throws IOException {
        this.buffer.clear();
        this.header(event);
        this.message(event);
        this.footer(event);
    }

    protected abstract void header(Event var1) throws IOException;

    protected abstract void footer(Event var1) throws IOException;

    protected void message(Event event) throws IOException {
        this.append("subject", event.subject());
        this.append("type", (Object)event.type());
        this.append("subtype", (Object)event.subtype());
        Object message = null;
        switch (event.type()) {
            case "shell": {
                this.append(event, "script");
                this.append(event, "command");
                this.append(event, "exception");
                break;
            }
            case "login": {
                this.append(event, "username");
                break;
            }
            case "jmx": {
                this.append(event, "method");
                this.append(event, "signature");
                this.append(event, "params");
                this.append(event, "result");
                this.append(event, "exception");
                break;
            }
            case "log": {
                Bundle bundle = (Bundle)event.getProperty("bundle");
                if (bundle != null) {
                    this.append("bundle.id", bundle.getBundleId());
                    this.append("bundle.symbolicname", (Object)bundle.getSymbolicName());
                    this.append("bundle.version", bundle.getVersion());
                }
                this.append(event, "message");
                this.append(event, "exception");
                break;
            }
            case "bundle": {
                Bundle bundle = (Bundle)event.getProperty("bundle");
                this.append("bundle.id", bundle.getBundleId());
                this.append("bundle.symbolicname", (Object)bundle.getSymbolicName());
                this.append("bundle.version", bundle.getVersion());
                break;
            }
            case "service": {
                ServiceEvent se = (ServiceEvent)event.getProperty("event");
                this.append("service.bundleid", se.getServiceReference().getProperty("service.bundleid"));
                this.append("service.id", se.getServiceReference().getProperty("service.id"));
                this.append("objectClass", se.getServiceReference().getProperty("objectClass"));
                break;
            }
            case "web": {
                this.append(event, "servlet.servlet");
                this.append(event, "servlet.alias");
                break;
            }
            case "repositories": {
                this.append(event, "uri");
                break;
            }
            case "features": {
                this.append(event, "name");
                this.append(event, "version");
                break;
            }
            case "blueprint": {
                this.append(event, "bundle.id");
                this.append(event, "bundle.symbolicname");
                this.append(event, "bundle.version");
                break;
            }
            default: {
                for (String key : event.keys()) {
                    this.append(event, key);
                }
            }
        }
    }

    private void append(Event event, String key) throws IOException {
        this.append(key, event.getProperty(key));
    }

    protected abstract void append(String var1, Object var2) throws IOException;

    private static String hostname() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (UnknownHostException uhe) {
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface nic = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = nic.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        String hostname;
                        InetAddress address = addresses.nextElement();
                        if (address.isLoopbackAddress() || (hostname = address.getHostName()) == null) continue;
                        return hostname;
                    }
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            return "-";
        }
    }

    private static String procId() {
        try {
            return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        }
        catch (Exception ex) {
            try {
                return new File("/proc/self").getCanonicalFile().getName();
            }
            catch (IOException iOException) {
                return "-";
            }
        }
    }
}

