/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.audit;

import com.conversantmedia.util.concurrent.DisruptorBlockingQueue;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.apache.karaf.audit.Event;
import org.apache.karaf.audit.EventLayout;
import org.apache.karaf.audit.EventLogger;
import org.apache.karaf.audit.layout.GelfLayout;
import org.apache.karaf.audit.layout.Rfc3164Layout;
import org.apache.karaf.audit.layout.Rfc5424Layout;
import org.apache.karaf.audit.layout.SimpleLayout;
import org.apache.karaf.audit.logger.FileEventLogger;
import org.apache.karaf.audit.logger.JulEventLogger;
import org.apache.karaf.audit.logger.UdpEventLogger;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.Managed;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

@Services(requires={@RequireService(value=EventAdmin.class)})
@Managed(value="org.apache.karaf.audit")
public class Activator
extends BaseActivator
implements ManagedService {
    public static final String FILTER = "filter";
    public static final String QUEUE_TYPE = "queue.type";
    public static final String QUEUE_SIZE = "queue.size";
    public static final String RUNNER_IDLE_TIMEOUT = "runner.idle-timeout";
    public static final String RUNNER_FLUSH_TIMEOUT = "runner.flush-timeout";
    public static final String FILE_PREFIX = "file.";
    public static final String FILE_LAYOUT = "file.layout";
    public static final String FILE_ENABLED = "file.enabled";
    public static final String FILE_TARGET = "file.target";
    public static final String FILE_ENCODING = "file.encoding";
    public static final String FILE_POLICY = "file.policy";
    public static final String FILE_FILES = "file.files";
    public static final String FILE_COMPRESS = "file.compress";
    public static final String UDP_PREFIX = "udp.";
    public static final String UDP_LAYOUT = "udp.layout";
    public static final String UDP_ENABLED = "udp.enabled";
    public static final String UDP_HOST = "udp.host";
    public static final String UDP_PORT = "udp.port";
    public static final String UDP_ENCODING = "udp.encoding";
    public static final String TCP_PREFIX = "tcp.";
    public static final String TCP_LAYOUT = "tcp.layout";
    public static final String TCP_ENABLED = "tcp.enabled";
    public static final String TCP_HOST = "tcp.host";
    public static final String TCP_PORT = "tcp.port";
    public static final String TCP_ENCODING = "tcp.encoding";
    public static final String JUL_PREFIX = "jul.";
    public static final String JUL_LAYOUT = "jul.layout";
    public static final String JUL_ENABLED = "jul.enabled";
    public static final String JUL_LOGGER = "jul.logger";
    public static final String JUL_LEVEL = "jul.level";
    public static final String TOPICS = "topics";
    private static final EventImpl STOP_EVENT = new EventImpl(new org.osgi.service.event.Event("stop", Collections.emptyMap()));
    private BlockingQueue<EventImpl> queue;
    private volatile Thread runner;
    private List<EventLogger> eventLoggers;
    private Filter filter;

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.queue = this.createQueue();
        this.eventLoggers = this.createLoggers();
        this.filter = this.createFilter();
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        ((Dictionary)props).put("event.topics", this.getTopics());
        this.register(EventHandler.class, this::handleEvent, props);
        if (!this.queue.isEmpty()) {
            this.startRunner();
        }
    }

    private String[] getTopics() {
        return this.getString(TOPICS, "*").split("\\s*,\\s*");
    }

    private Filter createFilter() throws InvalidSyntaxException {
        String str = this.getString(FILTER, null);
        return str != null ? FrameworkUtil.createFilter((String)str) : null;
    }

    private BlockingQueue<EventImpl> createQueue() throws Exception {
        String type = this.getString(QUEUE_TYPE, null);
        int size = this.getInt(QUEUE_SIZE, 1024);
        if ("ArrayBlockingQueue".equals(type)) {
            return new ArrayBlockingQueue<EventImpl>(size);
        }
        if ("DisruptorBlockingQueue".equals(type)) {
            return new DisruptorBlockingQueue(size);
        }
        if (type != null) {
            this.logger.warn("Unknown queue type: " + type + "");
        }
        try {
            return new DisruptorBlockingQueue(size);
        }
        catch (NoClassDefFoundError t) {
            return new ArrayBlockingQueue<EventImpl>(size);
        }
    }

    private List<EventLogger> createLoggers() throws Exception {
        try {
            String encoding;
            String host;
            ArrayList<EventLogger> loggers = new ArrayList<EventLogger>();
            if (this.getBoolean(FILE_ENABLED, true)) {
                String path = this.getString(FILE_TARGET, System.getProperty("karaf.data") + "/log/audit.txt");
                String encoding2 = this.getString(FILE_ENCODING, "UTF-8");
                String policy = this.getString(FILE_POLICY, "size(8mb)");
                int files = this.getInt(FILE_FILES, 32);
                boolean compress = this.getBoolean(FILE_COMPRESS, true);
                EventLayout layout = this.createLayout(this.getString(FILE_LAYOUT, FILE_LAYOUT));
                loggers.add(new FileEventLogger(path, encoding2, policy, files, compress, this, layout));
            }
            if (this.getBoolean(UDP_ENABLED, false)) {
                host = this.getString(UDP_HOST, "localhost");
                int port = this.getInt(UDP_PORT, 514);
                encoding = this.getString(UDP_ENCODING, "UTF-8");
                EventLayout layout = this.createLayout(this.getString(UDP_LAYOUT, UDP_LAYOUT));
                loggers.add(new UdpEventLogger(host, port, encoding, layout));
            }
            if (this.getBoolean(TCP_ENABLED, false)) {
                host = this.getString(TCP_HOST, "localhost");
                int port = this.getInt(TCP_PORT, 0);
                encoding = this.getString(TCP_ENCODING, "UTF-8");
                EventLayout layout = this.createLayout(this.getString(TCP_LAYOUT, TCP_LAYOUT));
                loggers.add(new UdpEventLogger(host, port, encoding, layout));
            }
            if (this.getBoolean(JUL_ENABLED, false)) {
                String logger = this.getString(JUL_LOGGER, "audit");
                String level = this.getString(JUL_LEVEL, "info");
                EventLayout layout = this.createLayout(this.getString(JUL_LAYOUT, JUL_LAYOUT));
                loggers.add(new JulEventLogger(logger, level, layout));
            }
            return loggers;
        }
        catch (IOException e) {
            throw new Exception("Error creating audit logger", e);
        }
    }

    private EventLayout createLayout(String prefix) {
        String type;
        switch (type = this.getString(prefix + ".type", "simple")) {
            case "simple": {
                return new SimpleLayout();
            }
            case "rfc3164": {
                return new Rfc3164Layout(this.getInt(prefix + ".facility", 16), this.getInt(prefix + ".priority", 5), this.getInt(prefix + ".enterprise", 18060), TimeZone.getDefault(), Locale.ENGLISH);
            }
            case "rfc5424": {
                return new Rfc5424Layout(this.getInt(prefix + ".facility", 16), this.getInt(prefix + ".priority", 5), this.getInt(prefix + ".enterprise", 18060), TimeZone.getDefault());
            }
            case "gelf": {
                return new GelfLayout();
            }
        }
        try {
            return this.createCustomLayout(type);
        }
        catch (Exception e) {
            this.logger.error("Error creating layout: " + type + ". Using a simple layout.", (Throwable)e);
            return new SimpleLayout();
        }
    }

    private EventLayout createCustomLayout(String type) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(type);
        Constructor<?> cnsMap = null;
        Constructor<?> cnsDef = null;
        Object layout = null;
        try {
            cnsMap = clazz.getConstructor(Map.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            cnsDef = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (cnsMap != null) {
            HashMap params = new HashMap();
            Enumeration<String> e = this.getConfiguration().keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                Object val = this.getConfiguration().get(key);
                params.put(key, val);
            }
            layout = cnsMap.newInstance(params);
        } else if (cnsDef != null) {
            layout = cnsDef.newInstance(new Object[0]);
        } else {
            throw new IllegalArgumentException("Unable to find a supported constructor");
        }
        if (layout instanceof EventLayout) {
            return layout;
        }
        throw new IllegalArgumentException("The built layout does not implement " + EventLayout.class.getName());
    }

    @Override
    protected void doStop() {
        List<EventLogger> eventLoggers;
        Thread runner = this.runner;
        if (runner != null && runner.isAlive()) {
            try {
                this.queue.add(STOP_EVENT);
                runner.join(5000L);
                if (runner.isAlive()) {
                    runner.interrupt();
                }
            }
            catch (InterruptedException e) {
                this.logger.debug("Error waiting for audit runner buffer stop");
            }
        }
        if ((eventLoggers = this.eventLoggers) != null) {
            for (EventLogger eventLogger : eventLoggers) {
                try {
                    eventLogger.close();
                }
                catch (IOException e) {
                    this.logger.debug("Error closing audit logger", (Throwable)e);
                }
            }
            this.eventLoggers = null;
        }
        super.doStop();
    }

    private void handleEvent(org.osgi.service.event.Event event) {
        try {
            EventImpl ev = new EventImpl(event);
            if (this.filter == null || this.filter.matches(ev.getFilterMap())) {
                this.queue.put(new EventImpl(event));
                this.startRunner();
            }
        }
        catch (InterruptedException e) {
            this.logger.debug("Interrupted while putting event in queue", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRunner() {
        if (this.eventLoggers != null && !this.eventLoggers.isEmpty() && this.runner == null) {
            Activator activator = this;
            synchronized (activator) {
                if (this.runner == null) {
                    this.runner = new Thread(this::consume, "audit-logger");
                    this.runner.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consume() {
        long maxIdle = this.getLong(RUNNER_IDLE_TIMEOUT, TimeUnit.MINUTES.toMillis(1L));
        long flushDelay = this.getLong(RUNNER_FLUSH_TIMEOUT, TimeUnit.MILLISECONDS.toMillis(100L));
        try {
            EventImpl event;
            List<EventLogger> eventLoggers = this.eventLoggers;
            BlockingQueue<EventImpl> queue = this.queue;
            while ((event = queue.poll(maxIdle, TimeUnit.MILLISECONDS)) != null) {
                if (event == STOP_EVENT) {
                    return;
                }
                for (EventLogger eventLogger : eventLoggers) {
                    eventLogger.write(event);
                }
                if (flushDelay > 0L) {
                    while ((event = queue.poll(flushDelay, TimeUnit.MILLISECONDS)) != null) {
                        if (event == STOP_EVENT) {
                            return;
                        }
                        for (EventLogger eventLogger : eventLoggers) {
                            eventLogger.write(event);
                        }
                    }
                }
                for (EventLogger eventLogger : eventLoggers) {
                    eventLogger.flush();
                }
            }
        }
        catch (Throwable e) {
            this.logger.warn("Error writing audit log", e);
        }
        finally {
            this.runner = null;
        }
    }

    static class EventImpl
    implements Event {
        private final org.osgi.service.event.Event event;
        private final long timestamp;
        private final String type;
        private final String subtype;

        EventImpl(org.osgi.service.event.Event event) {
            this.event = event;
            this.timestamp = this._timestamp();
            this.type = this._type();
            this.subtype = this._subtype();
        }

        @Override
        public long timestamp() {
            return this.timestamp;
        }

        private long _timestamp() {
            Long l = (Long)this.event.getProperty("timestamp");
            return l != null ? l : System.currentTimeMillis();
        }

        @Override
        public Subject subject() {
            return (Subject)this.event.getProperty("subject");
        }

        @Override
        public String type() {
            return this.type;
        }

        private String _type() {
            switch (this.event.getTopic()) {
                case "org/apache/karaf/shell/console/EXECUTED": {
                    return "shell";
                }
                case "org/osgi/service/log/LogEntry/LOG_ERROR": 
                case "org/osgi/service/log/LogEntry/LOG_WARNING": 
                case "org/osgi/service/log/LogEntry/LOG_INFO": 
                case "org/osgi/service/log/LogEntry/LOG_DEBUG": 
                case "org/osgi/service/log/LogEntry/LOG_OTHER": {
                    return "log";
                }
                case "org/osgi/framework/ServiceEvent/REGISTERED": 
                case "org/osgi/framework/ServiceEvent/MODIFIED": 
                case "org/osgi/framework/ServiceEvent/UNREGISTERING": {
                    return "service";
                }
                case "org/osgi/framework/BundleEvent/INSTALLED": 
                case "org/osgi/framework/BundleEvent/STARTED": 
                case "org/osgi/framework/BundleEvent/STOPPED": 
                case "org/osgi/framework/BundleEvent/UPDATED": 
                case "org/osgi/framework/BundleEvent/UNINSTALLED": 
                case "org/osgi/framework/BundleEvent/RESOLVED": 
                case "org/osgi/framework/BundleEvent/UNRESOLVED": 
                case "org/osgi/framework/BundleEvent/STARTING": 
                case "org/osgi/framework/BundleEvent/STOPPING": {
                    return "bundle";
                }
                case "org/apache/karaf/login/ATTEMPT": 
                case "org/apache/karaf/login/SUCCESS": 
                case "org/apache/karaf/login/FAILURE": 
                case "org/apache/karaf/login/LOGOUT": {
                    return "login";
                }
                case "javax/management/MBeanServer/CREATEMBEAN": 
                case "javax/management/MBeanServer/REGISTERMBEAN": 
                case "javax/management/MBeanServer/UNREGISTERMBEAN": 
                case "javax/management/MBeanServer/GETOBJECTINSTANCE": 
                case "javax/management/MBeanServer/QUERYMBEANS": 
                case "javax/management/MBeanServer/ISREGISTERED": 
                case "javax/management/MBeanServer/GETMBEANCOUNT": 
                case "javax/management/MBeanServer/GETATTRIBUTE": 
                case "javax/management/MBeanServer/GETATTRIBUTES": 
                case "javax/management/MBeanServer/SETATTRIBUTE": 
                case "javax/management/MBeanServer/SETATTRIBUTES": 
                case "javax/management/MBeanServer/INVOKE": 
                case "javax/management/MBeanServer/GETDEFAULTDOMAIN": 
                case "javax/management/MBeanServer/GETDOMAINS": 
                case "javax/management/MBeanServer/ADDNOTIFICATIONLISTENER": 
                case "javax/management/MBeanServer/GETMBEANINFO": 
                case "javax/management/MBeanServer/ISINSTANCEOF": 
                case "javax/management/MBeanServer/INSTANTIATE": 
                case "javax/management/MBeanServer/DESERIALIZE": 
                case "javax/management/MBeanServer/GETCLASSLOADERFOR": 
                case "javax/management/MBeanServer/GETCLASSLOADER": {
                    return "jmx";
                }
                case "org/osgi/framework/FrameworkEvent/STARTED": 
                case "org/osgi/framework/FrameworkEvent/ERROR": 
                case "org/osgi/framework/FrameworkEvent/PACKAGES_REFRESHED": 
                case "org/osgi/framework/FrameworkEvent/STARTLEVEL_CHANGED": 
                case "org/osgi/framework/FrameworkEvent/WARNING": 
                case "org/osgi/framework/FrameworkEvent/INFO": 
                case "org/osgi/framework/FrameworkEvent/STOPPED": 
                case "org/osgi/framework/FrameworkEvent/STOPPED_UPDATE": 
                case "org/osgi/framework/FrameworkEvent/STOPPED_BOOTCLASSPATH_MODIFIED": 
                case "org/osgi/framework/FrameworkEvent/WAIT_TIMEDOUT": {
                    return "framework";
                }
                case "org/osgi/service/web/DEPLOYING": 
                case "org/osgi/service/web/DEPLOYED": 
                case "org/osgi/service/web/UNDEPLOYING": 
                case "org/osgi/service/web/UNDEPLOYED": {
                    return "web";
                }
                case "org/apache/karaf/features/repositories/ADDED": 
                case "org/apache/karaf/features/repositories/REMOVED": {
                    return "repositories";
                }
                case "org/apache/karaf/features/features/INSTALLED": 
                case "org/apache/karaf/features/features/UNINSTALLED": {
                    return "features";
                }
                case "org/osgi/service/blueprint/container/CREATING": 
                case "org/osgi/service/blueprint/container/CREATED": 
                case "org/osgi/service/blueprint/container/DESTROYING": 
                case "org/osgi/service/blueprint/container/DESTROYED": 
                case "org/osgi/service/blueprint/container/FAILURE": 
                case "org/osgi/service/blueprint/container/GRACE_PERIOD": 
                case "org/osgi/service/blueprint/container/WAITING": {
                    return "blueprint";
                }
            }
            return "unknown";
        }

        @Override
        public String subtype() {
            return this.subtype;
        }

        private String _subtype() {
            String topic = this.event.getTopic();
            String subtype = topic.substring(topic.lastIndexOf(47) + 1).toLowerCase(Locale.ENGLISH);
            if (subtype.startsWith("log_")) {
                subtype = subtype.substring("log_".length());
            }
            return subtype;
        }

        @Override
        public Iterable<String> keys() {
            Object[] keys = this.event.getPropertyNames();
            Arrays.sort(keys);
            return () -> this.lambda$keys$0((String[])keys);
        }

        @Override
        public Object getProperty(String key) {
            return this.event.getProperty(key);
        }

        Map<String, Object> getFilterMap() {
            return new AbstractMap<String, Object>(){

                @Override
                public Set<Map.Entry<String, Object>> entrySet() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Object get(Object key) {
                    String s;
                    switch (s = key.toString()) {
                        case "timestamp": {
                            return this.timestamp();
                        }
                        case "type": {
                            return this.type();
                        }
                        case "subtype": {
                            return this.subtype();
                        }
                        case "subject": {
                            return this.subject();
                        }
                    }
                    return event.getProperty(s);
                }
            };
        }

        private /* synthetic */ Iterator lambda$keys$0(final String[] keys) {
            return new Iterator<String>(){
                String next;
                int index = -1;

                @Override
                public boolean hasNext() {
                    if (this.next != null) {
                        return true;
                    }
                    block10: while (++this.index < keys.length) {
                        switch (keys[this.index]) {
                            case "timestamp": 
                            case "event.topics": 
                            case "subject": 
                            case "type": 
                            case "subtype": {
                                continue block10;
                            }
                        }
                        this.next = keys[this.index];
                        return true;
                    }
                    return false;
                }

                @Override
                public String next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    String str = this.next;
                    this.next = null;
                    return str;
                }
            };
        }
    }
}

