/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jms.pool.narayana;

import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.tm.XAResourceRecovery;
import org.messaginghub.pooled.jms.JmsPoolXAConnectionFactory;
import org.ops4j.pax.jms.pool.narayana.CloseableConnectionFactory;
import org.ops4j.pax.jms.pool.narayana.PooledJmsPooledConnectionFactoryFactory;
import org.ops4j.pax.jms.service.ConnectionFactoryFactory;
import org.ops4j.pax.jms.service.internal.BeanConfig;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledJmsXAPooledConnectionFactoryFactory
extends PooledJmsPooledConnectionFactoryFactory {
    public static final Logger LOG = LoggerFactory.getLogger(PooledJmsXAPooledConnectionFactoryFactory.class);
    private final TransactionManager transactionManager;
    private final BundleContext bundleContext;
    private ServiceRegistration<XAResourceRecovery> recovery;

    public PooledJmsXAPooledConnectionFactoryFactory(BundleContext bundleContext, TransactionManager transactionManager) {
        this.bundleContext = bundleContext;
        this.transactionManager = transactionManager;
    }

    @Override
    public ConnectionFactory create(ConnectionFactoryFactory cff, Map<String, Object> props) throws JMSRuntimeException {
        try {
            XAConnectionFactory cf = cff.createXAConnectionFactory(BeanConfig.getNonPoolProps(props));
            JmsPoolXAConnectionFactory pool = new JmsPoolXAConnectionFactory();
            pool.setConnectionFactory((Object)cf);
            pool.setTransactionManager(this.transactionManager);
            BeanConfig.configure((Object)pool, BeanConfig.getPoolProps(props));
            this.recovery = this.bundleContext.registerService(XAResourceRecovery.class, () -> {
                try {
                    return new XAResource[]{new Wrapper(cf.createXAConnection())};
                }
                catch (JMSException e) {
                    throw new RuntimeException(e);
                }
            }, null);
            return new CloseableConnectionFactory((ConnectionFactory)pool){

                @Override
                public void close() throws Exception {
                    PooledJmsXAPooledConnectionFactoryFactory.this.recovery.unregister();
                }
            };
        }
        catch (Throwable e) {
            LOG.error("Error creating pooled connection factory: " + e.getMessage(), e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    class Wrapper
    implements XAResource {
        private final XAConnection xaConnection;
        private final XAResource xaResource;

        Wrapper(XAConnection xaConnection) throws JMSException {
            this.xaConnection = xaConnection;
            this.xaResource = xaConnection.createXASession().getXAResource();
        }

        @Override
        public void commit(Xid xid, boolean b) throws XAException {
            this.xaResource.commit(xid, b);
        }

        @Override
        public void end(Xid xid, int i) throws XAException {
            this.xaResource.end(xid, i);
        }

        @Override
        public void forget(Xid xid) throws XAException {
            this.xaResource.forget(xid);
        }

        @Override
        public int getTransactionTimeout() throws XAException {
            return this.xaResource.getTransactionTimeout();
        }

        @Override
        public boolean isSameRM(XAResource xaResource) throws XAException {
            return this.xaResource.isSameRM(xaResource);
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            return this.xaResource.prepare(xid);
        }

        @Override
        public Xid[] recover(int i) throws XAException {
            if (i == 0x800000) {
                try {
                    this.xaConnection.close();
                    return null;
                }
                catch (JMSException e) {
                    throw (XAException)new XAException(-3).initCause(e);
                }
            }
            return this.xaResource.recover(i);
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            this.xaResource.rollback(xid);
        }

        @Override
        public boolean setTransactionTimeout(int i) throws XAException {
            return this.xaResource.setTransactionTimeout(i);
        }

        @Override
        public void start(Xid xid, int i) throws XAException {
            this.xaResource.start(xid, i);
        }
    }
}

