/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

@NonNullByDefault
@NotThreadSafe
final class ModificationPath
implements Mutable {
    private static final int DEFAULT_ALLOC_SIZE = 8;
    private static final int ALLOC_SIZE = Integer.getInteger("org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationPath.ALLOC_SIZE", 8);
    private final YangInstanceIdentifier root;
    private YangInstanceIdentifier.PathArgument[] entries = new YangInstanceIdentifier.PathArgument[ALLOC_SIZE];
    private int used;

    ModificationPath(YangInstanceIdentifier root) {
        this.root = Objects.requireNonNull(root);
    }

    void push(YangInstanceIdentifier.PathArgument arg) {
        if (this.entries.length == this.used) {
            int grow = this.used <= 32 ? this.used : this.used / 2;
            this.entries = Arrays.copyOf(this.entries, this.used + grow);
        }
        this.entries[this.used++] = Objects.requireNonNull(arg);
    }

    void pop() {
        Preconditions.checkState((this.used > 0 ? 1 : 0) != 0, (Object)"No elements left");
        --this.used;
    }

    YangInstanceIdentifier toInstanceIdentifier() {
        return YangInstanceIdentifier.builder((YangInstanceIdentifier)this.root).append(Arrays.asList(this.entries).subList(0, this.used)).build();
    }

    public String toString() {
        return this.toInstanceIdentifier().toString();
    }
}

