/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.RequiredElementCountException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ChildTrackingPolicy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationPath;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.NodeModification;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraint;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraintAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MinMaxElementsValidation<T extends DataSchemaNode & ElementCountConstraintAware>
extends ModificationApplyOperation {
    private static final Logger LOG = LoggerFactory.getLogger(MinMaxElementsValidation.class);
    private final SchemaAwareApplyOperation<T> delegate;
    private final int minElements;
    private final int maxElements;

    private MinMaxElementsValidation(SchemaAwareApplyOperation<T> delegate, Integer minElements, Integer maxElements) {
        this.delegate = Objects.requireNonNull(delegate);
        this.minElements = minElements != null ? minElements : 0;
        this.maxElements = maxElements != null ? maxElements : Integer.MAX_VALUE;
    }

    static <T extends DataSchemaNode & ElementCountConstraintAware> ModificationApplyOperation from(SchemaAwareApplyOperation<T> delegate) {
        Optional optConstraint = ((ElementCountConstraintAware)((DataSchemaNode)delegate.getSchema())).getElementCountConstraint();
        if (!optConstraint.isPresent()) {
            return delegate;
        }
        ElementCountConstraint constraint = (ElementCountConstraint)optConstraint.get();
        return new MinMaxElementsValidation<T>(delegate, constraint.getMinElements(), constraint.getMaxElements());
    }

    @Override
    Optional<TreeNode> apply(ModifiedNode modification, Optional<TreeNode> storeMeta, Version version) {
        Optional<TreeNode> ret = modification.getValidatedNode(this, storeMeta);
        if (ret == null && (ret = this.delegate.apply(modification, storeMeta, version)).isPresent()) {
            this.checkChildren(ret.get().getData());
        }
        return ret;
    }

    @Override
    void checkApplicable(ModificationPath path, NodeModification modification, Optional<TreeNode> current, Version version) throws DataValidationFailedException {
        this.delegate.checkApplicable(path, modification, current, version);
        if (!(modification instanceof ModifiedNode)) {
            LOG.debug("Could not validate {}, does not implement expected class {}", (Object)modification, ModifiedNode.class);
            return;
        }
        ModifiedNode modified = (ModifiedNode)modification;
        Optional<TreeNode> maybeApplied = this.delegate.apply(modified, current, version);
        if (maybeApplied.isPresent()) {
            this.validateMinMaxElements(path, maybeApplied.get().getData());
        }
        modified.setValidatedNode(this, current, maybeApplied);
    }

    @Override
    void fullVerifyStructure(NormalizedNode<?, ?> modification) {
        this.delegate.fullVerifyStructure(modification);
        this.checkChildren(modification);
    }

    @Override
    public Optional<ModificationApplyOperation> getChild(YangInstanceIdentifier.PathArgument child) {
        return this.delegate.getChild(child);
    }

    @Override
    ChildTrackingPolicy getChildPolicy() {
        return this.delegate.getChildPolicy();
    }

    @Override
    void mergeIntoModifiedNode(ModifiedNode node, NormalizedNode<?, ?> value, Version version) {
        this.delegate.mergeIntoModifiedNode(node, value, version);
    }

    @Override
    void quickVerifyStructure(NormalizedNode<?, ?> modification) {
        this.delegate.quickVerifyStructure(modification);
    }

    @Override
    void recursivelyVerifyStructure(NormalizedNode<?, ?> value) {
        this.delegate.recursivelyVerifyStructure(value);
    }

    private void validateMinMaxElements(ModificationPath path, NormalizedNode<?, ?> value) throws DataValidationFailedException {
        YangInstanceIdentifier.PathArgument id = value.getIdentifier();
        int children = MinMaxElementsValidation.numOfChildrenFromValue(value);
        if (this.minElements > children) {
            throw new RequiredElementCountException(path.toInstanceIdentifier(), this.minElements, this.maxElements, children, "%s does not have enough elements (%s), needs at least %s", new Object[]{id, children, this.minElements});
        }
        if (this.maxElements < children) {
            throw new RequiredElementCountException(path.toInstanceIdentifier(), this.minElements, this.maxElements, children, "%s has too many elements (%s), can have at most %s", new Object[]{id, children, this.maxElements});
        }
    }

    private void checkChildren(NormalizedNode<?, ?> value) {
        YangInstanceIdentifier.PathArgument id = value.getIdentifier();
        int children = MinMaxElementsValidation.numOfChildrenFromValue(value);
        Preconditions.checkArgument((this.minElements <= children ? 1 : 0) != 0, (String)"Node %s does not have enough elements (%s), needs at least %s", (Object)id, (Object)children, (Object)this.minElements);
        Preconditions.checkArgument((this.maxElements >= children ? 1 : 0) != 0, (String)"Node %s has too many elements (%s), can have at most %s", (Object)id, (Object)children, (Object)this.maxElements);
    }

    private static int numOfChildrenFromValue(NormalizedNode<?, ?> value) {
        if (value instanceof NormalizedNodeContainer) {
            return ((NormalizedNodeContainer)value).getValue().size();
        }
        if (value instanceof UnkeyedListNode) {
            return ((UnkeyedListNode)value).getSize();
        }
        throw new IllegalArgumentException(String.format("Unexpected type '%s', expected types are NormalizedNodeContainer and UnkeyedListNode", value.getClass()));
    }
}

