/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ConflictingModificationAppliedException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModifiedNodeDoesNotExistException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.TreeType;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.MutableTreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNodeFactory;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ChildTrackingPolicy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.LogicalOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationPath;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.NodeModification;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.NormalizedNodeContainerSupport;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.SchemaValidationFailedException;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;

abstract class AbstractNodeContainerModificationStrategy<T extends DocumentedNode.WithStatus>
extends SchemaAwareApplyOperation<T> {
    private static final Version FAKE_VERSION = Version.initial();
    private final NormalizedNodeContainerSupport<?, ?> support;
    private final boolean verifyChildrenStructure;

    AbstractNodeContainerModificationStrategy(NormalizedNodeContainerSupport<?, ?> support, DataTreeConfiguration treeConfig) {
        this.support = Objects.requireNonNull(support);
        this.verifyChildrenStructure = treeConfig.getTreeType() == TreeType.CONFIGURATION;
    }

    @Override
    protected final ChildTrackingPolicy getChildPolicy() {
        return this.support.childPolicy;
    }

    @Override
    final void verifyValue(NormalizedNode<?, ?> writtenValue) {
        Class nodeClass = this.support.requiredClass;
        Preconditions.checkArgument((boolean)nodeClass.isInstance(writtenValue), (String)"Node %s is not of type %s", writtenValue, nodeClass);
        Preconditions.checkArgument((boolean)(writtenValue instanceof NormalizedNodeContainer));
    }

    @Override
    final void verifyValueChildren(NormalizedNode<?, ?> writtenValue) {
        if (this.verifyChildrenStructure) {
            NormalizedNodeContainer container = (NormalizedNodeContainer)writtenValue;
            for (Object child : container.getValue()) {
                Preconditions.checkArgument((boolean)(child instanceof NormalizedNode));
                NormalizedNode castedChild = (NormalizedNode)child;
                Optional<ModificationApplyOperation> childOp = this.getChild(castedChild.getIdentifier());
                if (childOp.isPresent()) {
                    childOp.get().fullVerifyStructure(castedChild);
                    continue;
                }
                throw new SchemaValidationFailedException(String.format("Node %s is not a valid child of %s according to the schema.", castedChild.getIdentifier(), container.getIdentifier()));
            }
            this.optionalVerifyValueChildren(writtenValue);
        }
        this.mandatoryVerifyValueChildren(writtenValue);
    }

    void optionalVerifyValueChildren(NormalizedNode<?, ?> writtenValue) {
    }

    void mandatoryVerifyValueChildren(NormalizedNode<?, ?> writtenValue) {
    }

    @Override
    protected final void recursivelyVerifyStructure(NormalizedNode<?, ?> value) {
        NormalizedNodeContainer container = (NormalizedNodeContainer)value;
        for (Object child : container.getValue()) {
            Preconditions.checkArgument((boolean)(child instanceof NormalizedNode));
            NormalizedNode castedChild = (NormalizedNode)child;
            Optional<ModificationApplyOperation> childOp = this.getChild(castedChild.getIdentifier());
            if (!childOp.isPresent()) {
                throw new SchemaValidationFailedException(String.format("Node %s is not a valid child of %s according to the schema.", castedChild.getIdentifier(), container.getIdentifier()));
            }
            childOp.get().recursivelyVerifyStructure(castedChild);
        }
    }

    @Override
    protected TreeNode applyWrite(ModifiedNode modification, NormalizedNode<?, ?> newValue, Optional<TreeNode> currentMeta, Version version) {
        TreeNode newValueMeta = TreeNodeFactory.createTreeNode(newValue, (Version)version);
        if (modification.getChildren().isEmpty()) {
            return newValueMeta;
        }
        MutableTreeNode mutable = newValueMeta.mutable();
        mutable.setSubtreeVersion(version);
        NormalizedNodeContainerBuilder<?, ?, ?, ?> dataBuilder = this.support.createBuilder(newValue);
        TreeNode result = this.mutateChildren(mutable, dataBuilder, version, modification.getChildren());
        return TreeNodeFactory.createTreeNode((NormalizedNode)result.getData(), (Version)version);
    }

    private TreeNode mutateChildren(MutableTreeNode meta, NormalizedNodeContainerBuilder data, Version nodeVersion, Iterable<ModifiedNode> modifications) {
        for (ModifiedNode mod : modifications) {
            YangInstanceIdentifier.PathArgument id = mod.getIdentifier();
            Optional cm = meta.getChild(id);
            Optional<TreeNode> result = this.resolveChildOperation(id).apply(mod, cm, nodeVersion);
            if (result.isPresent()) {
                TreeNode tn = result.get();
                meta.addChild(tn);
                data.addChild(tn.getData());
                continue;
            }
            meta.removeChild(id);
            data.removeChild(id);
        }
        meta.setData(data.build());
        return meta.seal();
    }

    @Override
    protected TreeNode applyMerge(ModifiedNode modification, TreeNode currentMeta, Version version) {
        NormalizedNode<?, ?> value = modification.getWrittenValue();
        Verify.verify((boolean)(value instanceof NormalizedNodeContainer), (String)"Attempted to merge non-container %s", value);
        Collection children = ((NormalizedNodeContainer)value).getValue();
        for (NormalizedNode c : children) {
            YangInstanceIdentifier.PathArgument id = c.getIdentifier();
            modification.modifyChild(id, this.resolveChildOperation(id), version);
        }
        return this.applyTouch(modification, currentMeta, version);
    }

    private void mergeChildrenIntoModification(ModifiedNode modification, Collection<NormalizedNode<?, ?>> children, Version version) {
        for (NormalizedNode<?, ?> c : children) {
            ModificationApplyOperation childOp = this.resolveChildOperation(c.getIdentifier());
            ModifiedNode childNode = modification.modifyChild(c.getIdentifier(), childOp, version);
            childOp.mergeIntoModifiedNode(childNode, c, version);
        }
    }

    @Override
    final void mergeIntoModifiedNode(ModifiedNode modification, NormalizedNode<?, ?> value, Version version) {
        Collection children = ((NormalizedNodeContainer)value).getValue();
        switch (modification.getOperation()) {
            case NONE: {
                this.recursivelyVerifyStructure(value);
                modification.updateValue(LogicalOperation.MERGE, value);
                return;
            }
            case TOUCH: {
                this.mergeChildrenIntoModification(modification, children, version);
                modification.updateValue(LogicalOperation.MERGE, this.support.createEmptyValue(value));
                return;
            }
            case MERGE: {
                this.mergeChildrenIntoModification(modification, children, version);
                modification.updateOperationType(LogicalOperation.MERGE);
                return;
            }
            case DELETE: {
                Optional<TreeNode> current;
                if (!modification.getChildren().isEmpty() && (current = this.apply(modification, modification.getOriginal(), Version.initial())).isPresent()) {
                    modification.updateValue(LogicalOperation.WRITE, current.get().getData());
                    this.mergeChildrenIntoModification(modification, children, version);
                    return;
                }
                modification.updateValue(LogicalOperation.WRITE, value);
                return;
            }
            case WRITE: {
                this.mergeChildrenIntoModification(modification, children, version);
                modification.updateOperationType(LogicalOperation.WRITE);
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported operation " + (Object)((Object)modification.getOperation()));
    }

    @Override
    protected TreeNode applyTouch(ModifiedNode modification, TreeNode currentMeta, Version version) {
        Collection<ModifiedNode> children = modification.getChildren();
        if (!children.isEmpty()) {
            NormalizedNodeContainerBuilder<?, ?, ?, ?> dataBuilder = this.support.createBuilder(currentMeta.getData());
            MutableTreeNode newMeta = currentMeta.mutable();
            newMeta.setSubtreeVersion(version);
            TreeNode ret = this.mutateChildren(newMeta, dataBuilder, version, children);
            for (ModifiedNode child : children) {
                if (child.getModificationType() == ModificationType.UNMODIFIED) continue;
                modification.resolveModificationType(ModificationType.SUBTREE_MODIFIED);
                return ret;
            }
        }
        modification.resolveModificationType(ModificationType.UNMODIFIED);
        return currentMeta;
    }

    @Override
    protected final void checkTouchApplicable(ModificationPath path, NodeModification modification, Optional<TreeNode> current, Version version) throws DataValidationFailedException {
        TreeNode currentNode;
        if (!current.isPresent()) {
            currentNode = this.defaultTreeNode();
            if (currentNode == null) {
                if (!modification.getOriginal().isPresent()) {
                    YangInstanceIdentifier id = path.toInstanceIdentifier();
                    throw new ModifiedNodeDoesNotExistException(id, String.format("Node %s does not exist. Cannot apply modification to its children.", id));
                }
                throw new ConflictingModificationAppliedException(path.toInstanceIdentifier(), "Node was deleted by other transaction.");
            }
        } else {
            currentNode = current.get();
        }
        this.checkChildPreconditions(path, modification, currentNode, version);
    }

    @Nullable TreeNode defaultTreeNode() {
        return null;
    }

    static final TreeNode defaultTreeNode(NormalizedNode<?, ?> emptyNode) {
        return TreeNodeFactory.createTreeNode(emptyNode, (Version)FAKE_VERSION);
    }

    @Override
    protected final void checkMergeApplicable(ModificationPath path, NodeModification modification, Optional<TreeNode> current, Version version) throws DataValidationFailedException {
        if (current.isPresent()) {
            this.checkChildPreconditions(path, modification, current.get(), version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkChildPreconditions(ModificationPath path, NodeModification modification, TreeNode current, Version version) throws DataValidationFailedException {
        for (NodeModification nodeModification : modification.getChildren()) {
            YangInstanceIdentifier.PathArgument childId = (YangInstanceIdentifier.PathArgument)nodeModification.getIdentifier();
            Optional childMeta = current.getChild(childId);
            path.push(childId);
            try {
                this.resolveChildOperation(childId).checkApplicable(path, nodeModification, childMeta, version);
            }
            finally {
                path.pop();
            }
        }
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("support", this.support).add("verifyChildren", this.verifyChildrenStructure);
    }

    static abstract class Visible<T extends DocumentedNode.WithStatus>
    extends AbstractNodeContainerModificationStrategy<T> {
        private final @NonNull T schema;

        Visible(NormalizedNodeContainerSupport<?, ?> support, DataTreeConfiguration treeConfig, T schema) {
            super(support, treeConfig);
            this.schema = (DocumentedNode.WithStatus)Objects.requireNonNull(schema);
        }

        @Override
        final T getSchema() {
            return this.schema;
        }

        @Override
        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return super.addToStringAttributes(helper).add("schema", this.schema);
        }
    }

    static abstract class Invisible<T extends DocumentedNode.WithStatus>
    extends AbstractNodeContainerModificationStrategy<T> {
        private final @NonNull SchemaAwareApplyOperation<T> entryStrategy;

        Invisible(NormalizedNodeContainerSupport<?, ?> support, DataTreeConfiguration treeConfig, SchemaAwareApplyOperation<T> entryStrategy) {
            super(support, treeConfig);
            this.entryStrategy = Objects.requireNonNull(entryStrategy);
        }

        @Override
        final T getSchema() {
            return this.entryStrategy.getSchema();
        }

        final Optional<ModificationApplyOperation> entryStrategy() {
            return Optional.of(this.entryStrategy);
        }

        @Override
        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return super.addToStringAttributes(helper).add("entry", this.entryStrategy);
        }
    }
}

