/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNodes;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;

abstract class AbstractModifiedNodeBasedCandidateNode
implements DataTreeCandidateNode {
    private final ModifiedNode mod;
    private final TreeNode newMeta;
    private final TreeNode oldMeta;

    protected AbstractModifiedNodeBasedCandidateNode(ModifiedNode mod, TreeNode oldMeta, TreeNode newMeta) {
        this.newMeta = newMeta;
        this.oldMeta = oldMeta;
        this.mod = Objects.requireNonNull(mod);
    }

    protected final ModifiedNode getMod() {
        return this.mod;
    }

    protected final TreeNode getNewMeta() {
        return this.newMeta;
    }

    protected final TreeNode getOldMeta() {
        return this.oldMeta;
    }

    private static TreeNode childMeta(TreeNode parent, YangInstanceIdentifier.PathArgument id) {
        return parent == null ? null : (TreeNode)parent.getChild(id).orElse(null);
    }

    private static boolean canHaveChildren(@Nullable TreeNode oldMeta, @Nullable TreeNode newMeta) {
        if (oldMeta != null) {
            return oldMeta.getData() instanceof NormalizedNodeContainer;
        }
        if (newMeta != null) {
            return newMeta.getData() instanceof NormalizedNodeContainer;
        }
        return false;
    }

    private static NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> getContainer(@Nullable TreeNode meta) {
        return meta == null ? null : (NormalizedNodeContainer)meta.getData();
    }

    private ChildNode childNode(ModifiedNode childMod) {
        YangInstanceIdentifier.PathArgument id = childMod.getIdentifier();
        return new ChildNode(childMod, AbstractModifiedNodeBasedCandidateNode.childMeta(this.oldMeta, id), AbstractModifiedNodeBasedCandidateNode.childMeta(this.newMeta, id));
    }

    public Collection<DataTreeCandidateNode> getChildNodes() {
        switch (this.mod.getModificationType()) {
            case APPEARED: 
            case DISAPPEARED: 
            case SUBTREE_MODIFIED: {
                return Collections2.transform(this.mod.getChildren(), this::childNode);
            }
            case UNMODIFIED: {
                if (!AbstractModifiedNodeBasedCandidateNode.canHaveChildren(this.oldMeta, this.newMeta)) {
                    return ImmutableList.of();
                }
                return Collections2.transform((Collection)AbstractModifiedNodeBasedCandidateNode.getContainer(this.newMeta != null ? this.newMeta : this.oldMeta).getValue(), DataTreeCandidateNodes::unmodified);
            }
            case DELETE: 
            case WRITE: {
                if (!AbstractModifiedNodeBasedCandidateNode.canHaveChildren(this.oldMeta, this.newMeta)) {
                    return ImmutableList.of();
                }
                return DataTreeCandidateNodes.containerDelta(AbstractModifiedNodeBasedCandidateNode.getContainer(this.oldMeta), AbstractModifiedNodeBasedCandidateNode.getContainer(this.newMeta));
            }
        }
        throw new IllegalArgumentException("Unhandled modification type " + this.mod.getModificationType());
    }

    public ModificationType getModificationType() {
        return (ModificationType)Verify.verifyNotNull((Object)this.mod.getModificationType(), (String)"Node %s does not have resolved modification type", (Object[])new Object[]{this.mod});
    }

    private static @NonNull Optional<NormalizedNode<?, ?>> optionalData(TreeNode meta) {
        return meta == null ? Optional.empty() : Optional.of(meta.getData());
    }

    public final Optional<NormalizedNode<?, ?>> getDataAfter() {
        return AbstractModifiedNodeBasedCandidateNode.optionalData(this.newMeta);
    }

    public final Optional<NormalizedNode<?, ?>> getDataBefore() {
        return AbstractModifiedNodeBasedCandidateNode.optionalData(this.oldMeta);
    }

    public final DataTreeCandidateNode getModifiedChild(YangInstanceIdentifier.PathArgument identifier) {
        switch (this.mod.getModificationType()) {
            case APPEARED: 
            case DISAPPEARED: 
            case SUBTREE_MODIFIED: {
                Optional<ModifiedNode> childMod = this.mod.getChild(identifier);
                if (childMod.isPresent()) {
                    return this.childNode(childMod.get());
                }
                return null;
            }
            case UNMODIFIED: {
                if (!AbstractModifiedNodeBasedCandidateNode.canHaveChildren(this.oldMeta, this.newMeta)) {
                    return null;
                }
                Optional maybeChild = AbstractModifiedNodeBasedCandidateNode.getContainer(this.newMeta != null ? this.newMeta : this.oldMeta).getChild(identifier);
                return maybeChild.isPresent() ? DataTreeCandidateNodes.unmodified((NormalizedNode)((NormalizedNode)maybeChild.get())) : null;
            }
            case DELETE: 
            case WRITE: {
                if (!AbstractModifiedNodeBasedCandidateNode.canHaveChildren(this.oldMeta, this.newMeta)) {
                    return null;
                }
                return DataTreeCandidateNodes.containerDelta(AbstractModifiedNodeBasedCandidateNode.getContainer(this.oldMeta), AbstractModifiedNodeBasedCandidateNode.getContainer(this.newMeta), (YangInstanceIdentifier.PathArgument)identifier);
            }
        }
        throw new IllegalArgumentException("Unhandled modification type " + this.mod.getModificationType());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{mod = " + this.mod + ", oldMeta = " + this.oldMeta + ", newMeta = " + this.newMeta + "}";
    }

    private static final class ChildNode
    extends AbstractModifiedNodeBasedCandidateNode {
        ChildNode(ModifiedNode mod, TreeNode oldMeta, TreeNode newMeta) {
            super(mod, oldMeta, newMeta);
        }

        public YangInstanceIdentifier.PathArgument getIdentifier() {
            return this.getMod().getIdentifier();
        }
    }
}

