/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.MapAdaptor;
import org.opendaylight.yangtools.util.UnmodifiableCollection;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.ListNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafSetEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.AbstractImmutableNormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.AbstractImmutableNormalizedValueNode;

public class ImmutableLeafSetNodeBuilder<T>
implements ListNodeBuilder<T, LeafSetEntryNode<T>> {
    private static final int DEFAULT_CAPACITY = 4;
    private final Map<YangInstanceIdentifier.NodeWithValue, LeafSetEntryNode<T>> value;
    private YangInstanceIdentifier.NodeIdentifier nodeIdentifier;

    protected ImmutableLeafSetNodeBuilder() {
        this.value = new HashMap<YangInstanceIdentifier.NodeWithValue, LeafSetEntryNode<T>>(4);
    }

    protected ImmutableLeafSetNodeBuilder(int sizeHint) {
        this.value = sizeHint >= 0 ? Maps.newHashMapWithExpectedSize((int)sizeHint) : new HashMap<YangInstanceIdentifier.NodeWithValue, LeafSetEntryNode<T>>(4);
    }

    protected ImmutableLeafSetNodeBuilder(ImmutableLeafSetNode<T> node) {
        this.nodeIdentifier = (YangInstanceIdentifier.NodeIdentifier)node.getIdentifier();
        this.value = MapAdaptor.getDefaultInstance().takeSnapshot(((ImmutableLeafSetNode)node).children);
    }

    public static <T> @NonNull ListNodeBuilder<T, LeafSetEntryNode<T>> create() {
        return new ImmutableLeafSetNodeBuilder<T>();
    }

    public static <T> @NonNull ListNodeBuilder<T, LeafSetEntryNode<T>> create(int sizeHint) {
        return new ImmutableLeafSetNodeBuilder<T>(sizeHint);
    }

    public static <T> @NonNull ListNodeBuilder<T, LeafSetEntryNode<T>> create(LeafSetNode<T> node) {
        if (!(node instanceof ImmutableLeafSetNode)) {
            throw new UnsupportedOperationException(String.format("Cannot initialize from class %s", node.getClass()));
        }
        return new ImmutableLeafSetNodeBuilder<T>((ImmutableLeafSetNode)node);
    }

    @Override
    public ListNodeBuilder<T, LeafSetEntryNode<T>> withChild(LeafSetEntryNode<T> child) {
        this.value.put(child.getIdentifier(), child);
        return this;
    }

    @Override
    public ListNodeBuilder<T, LeafSetEntryNode<T>> withoutChild(YangInstanceIdentifier.PathArgument key) {
        this.value.remove(key);
        return this;
    }

    @Override
    public LeafSetNode<T> build() {
        return new ImmutableLeafSetNode(this.nodeIdentifier, MapAdaptor.getDefaultInstance().optimize(this.value));
    }

    @Override
    public ListNodeBuilder<T, LeafSetEntryNode<T>> withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        this.nodeIdentifier = withNodeIdentifier;
        return this;
    }

    @Override
    public ListNodeBuilder<T, LeafSetEntryNode<T>> withValue(Collection<LeafSetEntryNode<T>> withValue) {
        for (LeafSetEntryNode<T> leafSetEntry : withValue) {
            this.withChild(leafSetEntry);
        }
        return this;
    }

    @Override
    public ListNodeBuilder<T, LeafSetEntryNode<T>> withChildValue(T childValue, Map<QName, String> attributes) {
        ImmutableLeafSetEntryNodeBuilder b = ImmutableLeafSetEntryNodeBuilder.create();
        b.withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeWithValue(this.nodeIdentifier.getNodeType(), childValue));
        b.withValue(childValue);
        b.withAttributes((Map)attributes);
        return this.withChild(b.build());
    }

    @Override
    public ListNodeBuilder<T, LeafSetEntryNode<T>> withChildValue(T childValue) {
        return this.withChildValue(childValue, (Map<QName, String>)ImmutableMap.of());
    }

    @Override
    public NormalizedNodeContainerBuilder<YangInstanceIdentifier.NodeIdentifier, YangInstanceIdentifier.PathArgument, LeafSetEntryNode<T>, LeafSetNode<T>> addChild(LeafSetEntryNode<T> child) {
        return this.withChild(child);
    }

    @Override
    public NormalizedNodeContainerBuilder<YangInstanceIdentifier.NodeIdentifier, YangInstanceIdentifier.PathArgument, LeafSetEntryNode<T>, LeafSetNode<T>> removeChild(YangInstanceIdentifier.PathArgument key) {
        return this.withoutChild(key);
    }

    protected static final class ImmutableLeafSetNode<T>
    extends AbstractImmutableNormalizedValueNode<YangInstanceIdentifier.NodeIdentifier, Collection<LeafSetEntryNode<T>>>
    implements LeafSetNode<T> {
        private final Map<YangInstanceIdentifier.NodeWithValue, LeafSetEntryNode<T>> children;

        ImmutableLeafSetNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, Map<YangInstanceIdentifier.NodeWithValue, LeafSetEntryNode<T>> children) {
            super(nodeIdentifier, UnmodifiableCollection.create(children.values()));
            this.children = children;
        }

        public Optional<LeafSetEntryNode<T>> getChild(YangInstanceIdentifier.NodeWithValue child) {
            return Optional.ofNullable(this.children.get(child));
        }

        @Override
        protected int valueHashCode() {
            return this.children.hashCode();
        }

        @Override
        protected boolean valueEquals(AbstractImmutableNormalizedNode<?, ?> other) {
            return this.children.equals(((ImmutableLeafSetNode)other).children);
        }
    }
}

