/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Objects;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.odlext.model.api.YangModeledAnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.YangModeledAnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.InterningLeafSetNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeAttrBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.ListNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableAnyXmlNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableAugmentationNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableChoiceNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafSetNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableOrderedLeafSetNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableOrderedMapNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableUnkeyedListEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableUnkeyedListNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableYangModeledAnyXmlNodeBuilder;
import org.opendaylight.yangtools.yang.data.util.LeafInterner;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;

public class ImmutableNormalizedNodeStreamWriter
implements NormalizedNodeStreamWriter {
    private final Deque<NormalizedNodeContainerBuilder> builders = new ArrayDeque<NormalizedNodeContainerBuilder>();
    private DataSchemaNode nextSchema;

    protected ImmutableNormalizedNodeStreamWriter(NormalizedNodeContainerBuilder topLevelBuilder) {
        this.builders.push(topLevelBuilder);
    }

    protected ImmutableNormalizedNodeStreamWriter(NormalizedNodeResult result) {
        this(new NormalizedNodeResultBuilder(result));
    }

    public static @NonNull NormalizedNodeStreamWriter from(NormalizedNodeContainerBuilder<?, ?, ?, ?> builder) {
        return new ImmutableNormalizedNodeStreamWriter(builder);
    }

    public static NormalizedNodeStreamWriter from(NormalizedNodeResult result) {
        return new ImmutableNormalizedNodeStreamWriter(result);
    }

    protected Deque<NormalizedNodeContainerBuilder> getBuilders() {
        return this.builders;
    }

    protected NormalizedNodeContainerBuilder getCurrent() {
        return this.builders.peek();
    }

    private void enter(NormalizedNodeContainerBuilder next) {
        this.builders.push(next);
        this.nextSchema = null;
    }

    protected void writeChild(NormalizedNode<?, ?> child) {
        this.getCurrent().addChild(child);
    }

    public void endNode() {
        NormalizedNodeContainerBuilder finishedBuilder = this.builders.poll();
        Preconditions.checkState((finishedBuilder != null ? 1 : 0) != 0, (Object)"Node which should be closed does not exists.");
        NormalizedNodeContainerBuilder current = this.getCurrent();
        Preconditions.checkState((current != null ? 1 : 0) != 0, (Object)"Reached top level node, which could not be closed in this writer.");
        Object product = finishedBuilder.build();
        current.addChild(product);
        this.nextSchema = null;
    }

    public void leafNode(YangInstanceIdentifier.NodeIdentifier name, Object value) {
        this.checkDataNodeContainer();
        LeafNode sample = ImmutableNodes.leafNode(name, value);
        LeafNode node = this.nextSchema instanceof LeafSchemaNode ? (LeafNode)LeafInterner.forSchema((LeafSchemaNode)((LeafSchemaNode)this.nextSchema)).intern(sample) : sample;
        this.writeChild((NormalizedNode<?, ?>)node);
        this.nextSchema = null;
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        ListNodeBuilder builder = -1 == childSizeHint ? InterningLeafSetNodeBuilder.create(this.nextSchema) : InterningLeafSetNodeBuilder.create(this.nextSchema, childSizeHint);
        builder.withNodeIdentifier(name);
        this.enter(builder);
    }

    public void leafSetEntryNode(QName name, Object value) {
        if (this.getCurrent() instanceof ImmutableOrderedLeafSetNodeBuilder) {
            ImmutableOrderedLeafSetNodeBuilder builder = (ImmutableOrderedLeafSetNodeBuilder)this.getCurrent();
            builder.withChildValue(value);
        } else if (this.getCurrent() instanceof ImmutableLeafSetNodeBuilder) {
            ImmutableLeafSetNodeBuilder builder = (ImmutableLeafSetNodeBuilder)this.getCurrent();
            builder.withChildValue(value);
        } else {
            throw new IllegalArgumentException("LeafSetEntryNode is not valid for parent " + this.getCurrent());
        }
        this.nextSchema = null;
    }

    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        ListNodeBuilder builder = Builders.orderedLeafSetBuilder();
        builder.withNodeIdentifier(name);
        this.enter(builder);
    }

    public void anyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Object value) {
        this.checkDataNodeContainer();
        AnyXmlNode node = (AnyXmlNode)ImmutableAnyXmlNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)name).withValue((DOMSource)value).build();
        this.writeChild((NormalizedNode<?, ?>)node);
        this.nextSchema = null;
    }

    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        DataContainerNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode> builder = -1 == childSizeHint ? ImmutableContainerNodeBuilder.create() : ImmutableContainerNodeBuilder.create(childSizeHint);
        this.enter(builder.withNodeIdentifier((YangInstanceIdentifier.PathArgument)name));
    }

    public void startYangModeledAnyXmlNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        Preconditions.checkArgument((boolean)(this.nextSchema instanceof YangModeledAnyXmlSchemaNode), (Object)"Schema of this node should be instance of YangModeledAnyXmlSchemaNode");
        DataContainerNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifier, YangModeledAnyXmlNode> builder = -1 == childSizeHint ? ImmutableYangModeledAnyXmlNodeBuilder.create((YangModeledAnyXmlSchemaNode)this.nextSchema) : ImmutableYangModeledAnyXmlNodeBuilder.create((YangModeledAnyXmlSchemaNode)this.nextSchema, childSizeHint);
        this.enter(builder.withNodeIdentifier((YangInstanceIdentifier.PathArgument)name));
    }

    public void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> builder = -1 == childSizeHint ? ImmutableUnkeyedListNodeBuilder.create() : ImmutableUnkeyedListNodeBuilder.create(childSizeHint);
        this.enter(builder.withNodeIdentifier(name));
    }

    public void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        Preconditions.checkArgument((this.getCurrent() instanceof NormalizedNodeResultBuilder || this.getCurrent() instanceof ImmutableUnkeyedListNodeBuilder ? 1 : 0) != 0);
        DataContainerNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifier, UnkeyedListEntryNode> builder = -1 == childSizeHint ? ImmutableUnkeyedListEntryNodeBuilder.create() : ImmutableUnkeyedListEntryNodeBuilder.create(childSizeHint);
        this.enter(builder.withNodeIdentifier((YangInstanceIdentifier.PathArgument)name));
    }

    public void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        CollectionNodeBuilder<MapEntryNode, MapNode> builder = -1 == childSizeHint ? ImmutableMapNodeBuilder.create() : ImmutableMapNodeBuilder.create(childSizeHint);
        this.enter(builder.withNodeIdentifier(name));
    }

    public void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) {
        if (!(this.getCurrent() instanceof NormalizedNodeResultBuilder)) {
            Preconditions.checkArgument((this.getCurrent() instanceof ImmutableMapNodeBuilder || this.getCurrent() instanceof ImmutableOrderedMapNodeBuilder ? 1 : 0) != 0);
        }
        DataContainerNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> builder = -1 == childSizeHint ? ImmutableMapEntryNodeBuilder.create() : ImmutableMapEntryNodeBuilder.create(childSizeHint);
        this.enter(builder.withNodeIdentifier((YangInstanceIdentifier.PathArgument)identifier));
    }

    public void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        CollectionNodeBuilder<MapEntryNode, OrderedMapNode> builder = -1 == childSizeHint ? ImmutableOrderedMapNodeBuilder.create() : ImmutableOrderedMapNodeBuilder.create(childSizeHint);
        this.enter(builder.withNodeIdentifier(name));
    }

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ChoiceNode> builder = -1 == childSizeHint ? ImmutableChoiceNodeBuilder.create() : ImmutableChoiceNodeBuilder.create(childSizeHint);
        this.enter(builder.withNodeIdentifier((YangInstanceIdentifier.PathArgument)name));
    }

    public void startAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier identifier) {
        this.checkDataNodeContainer();
        Preconditions.checkArgument((!(this.getCurrent() instanceof ImmutableAugmentationNodeBuilder) ? 1 : 0) != 0);
        this.enter(Builders.augmentationBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)identifier));
    }

    private void checkDataNodeContainer() {
        NormalizedNodeContainerBuilder current = this.getCurrent();
        if (!(current instanceof NormalizedNodeResultBuilder)) {
            Preconditions.checkArgument((boolean)(current instanceof DataContainerNodeBuilder), (Object)"Invalid nesting of data.");
        }
    }

    public void flush() {
    }

    public void close() {
    }

    public void nextDataSchemaNode(DataSchemaNode schema) {
        this.nextSchema = Objects.requireNonNull(schema);
    }

    protected static final class NormalizedNodeResultBuilder
    implements NormalizedNodeContainerBuilder {
        private final NormalizedNodeResult result;

        public NormalizedNodeResultBuilder(NormalizedNodeResult result) {
            this.result = result;
        }

        @Override
        public NormalizedNodeBuilder withValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public NormalizedNodeContainerBuilder withValue(Collection value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NormalizedNode build() {
            throw new IllegalStateException("Can not close NormalizedNodeResult");
        }

        @Override
        public NormalizedNodeContainerBuilder withNodeIdentifier(YangInstanceIdentifier.PathArgument nodeIdentifier) {
            throw new UnsupportedOperationException();
        }

        public NormalizedNodeContainerBuilder addChild(NormalizedNode child) {
            this.result.setResult(child);
            return this;
        }

        public NormalizedNodeContainerBuilder removeChild(YangInstanceIdentifier.PathArgument key) {
            throw new UnsupportedOperationException();
        }
    }
}

