/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.leafref;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefContextBuilder;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefContextTreeBuilder;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefPath;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefUtils;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefYangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextProvider;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public final class LeafRefContext
implements SchemaContextProvider {
    private final QName currentNodeQName;
    private final SchemaPath currentNodePath;
    private final SchemaContext schemaContext;
    private final Module module;
    private final LeafRefPath leafRefTargetPath;
    private final LeafRefPath absoluteLeafRefTargetPath;
    private final String leafRefTargetPathString;
    private final boolean isReferencedBy;
    private final boolean isReferencing;
    private final ImmutableMap<QName, LeafRefContext> referencingChilds;
    private final ImmutableMap<QName, LeafRefContext> referencedByChilds;
    private final ImmutableMap<QName, LeafRefContext> referencedByLeafRefCtx;
    private volatile LeafRefPath leafRefNodePath = null;

    LeafRefContext(LeafRefContextBuilder leafRefContextBuilder) {
        this.currentNodeQName = leafRefContextBuilder.getCurrentNodeQName();
        this.currentNodePath = leafRefContextBuilder.getCurrentNodePath();
        this.schemaContext = leafRefContextBuilder.getSchemaContext();
        this.leafRefTargetPath = leafRefContextBuilder.getLeafRefTargetPath();
        this.absoluteLeafRefTargetPath = leafRefContextBuilder.getAbsoluteLeafRefTargetPath();
        this.leafRefTargetPathString = leafRefContextBuilder.getLeafRefTargetPathString();
        this.isReferencedBy = leafRefContextBuilder.isReferencedBy();
        this.isReferencing = leafRefContextBuilder.isReferencing();
        this.referencingChilds = ImmutableMap.copyOf(leafRefContextBuilder.getReferencingChilds());
        this.referencedByChilds = ImmutableMap.copyOf(leafRefContextBuilder.getReferencedByChilds());
        this.referencedByLeafRefCtx = ImmutableMap.copyOf(leafRefContextBuilder.getAllReferencedByLeafRefCtxs());
        this.module = leafRefContextBuilder.getLeafRefContextModule();
    }

    public static LeafRefContext create(SchemaContext ctx) {
        try {
            return new LeafRefContextTreeBuilder(ctx).buildLeafRefContextTree();
        }
        catch (LeafRefYangSyntaxErrorException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean hasLeafRefContextChild() {
        return this.hasReferencedChild() || this.hasReferencingChild();
    }

    public boolean hasReferencedChild() {
        return !this.referencedByChilds.isEmpty();
    }

    public boolean hasReferencingChild() {
        return !this.referencingChilds.isEmpty();
    }

    public boolean isReferenced() {
        return this.isReferencedBy;
    }

    public boolean isReferencing() {
        return this.isReferencing;
    }

    public LeafRefContext getReferencingChildByName(QName name) {
        return (LeafRefContext)this.referencingChilds.get((Object)name);
    }

    public Map<QName, LeafRefContext> getReferencingChilds() {
        return this.referencingChilds;
    }

    public LeafRefContext getReferencedChildByName(QName name) {
        return (LeafRefContext)this.referencedByChilds.get((Object)name);
    }

    public Map<QName, LeafRefContext> getReferencedByChilds() {
        return this.referencedByChilds;
    }

    public SchemaPath getCurrentNodePath() {
        return this.currentNodePath;
    }

    public LeafRefPath getLeafRefTargetPath() {
        return this.leafRefTargetPath;
    }

    public String getLeafRefTargetPathString() {
        return this.leafRefTargetPathString;
    }

    public QName getNodeName() {
        return this.currentNodeQName;
    }

    public SchemaContext getSchemaContext() {
        return this.schemaContext;
    }

    public LeafRefPath getAbsoluteLeafRefTargetPath() {
        return this.absoluteLeafRefTargetPath;
    }

    public Module getLeafRefContextModule() {
        return this.module;
    }

    public LeafRefContext getReferencedByLeafRefCtxByName(QName qname) {
        return (LeafRefContext)this.referencedByLeafRefCtx.get((Object)qname);
    }

    public Map<QName, LeafRefContext> getAllReferencedByLeafRefCtxs() {
        return this.referencedByLeafRefCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LeafRefPath getLeafRefNodePath() {
        LeafRefPath ret = this.leafRefNodePath;
        if (ret == null) {
            LeafRefContext leafRefContext = this;
            synchronized (leafRefContext) {
                ret = this.leafRefNodePath;
                if (ret == null) {
                    ret = this.leafRefNodePath = LeafRefUtils.schemaPathToLeafRefPath(this.currentNodePath, this.module);
                }
            }
        }
        return ret;
    }
}

