/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.codec.StringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.StringPatternCheckingCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;

@Beta
public class StringStringCodec
extends TypeDefinitionAwareCodec<String, StringTypeDefinition>
implements StringCodec<String> {
    private final LengthConstraint lengthConstraint;

    StringStringCodec(StringTypeDefinition typeDef) {
        super(Optional.of(typeDef), String.class);
        this.lengthConstraint = typeDef.getLengthConstraint().orElse(null);
    }

    public static StringStringCodec from(StringTypeDefinition normalizedType) {
        if (normalizedType.getPatternConstraints().isEmpty()) {
            return new StringStringCodec(normalizedType);
        }
        return new StringPatternCheckingCodec(normalizedType);
    }

    @Override
    public final String deserialize(String stringRepresentation) {
        this.validate(Objects.requireNonNull(stringRepresentation));
        return stringRepresentation;
    }

    @Override
    public final String serialize(String data) {
        return Objects.requireNonNull(data);
    }

    void validate(String str) {
        if (this.lengthConstraint != null) {
            Preconditions.checkArgument((boolean)this.lengthConstraint.getAllowedRanges().contains((Comparable)Integer.valueOf(str.length())), (String)"String '%s' does not match allowed length constraint %s", (Object)this.lengthConstraint);
        }
    }
}

