/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.RangeSet;
import java.math.BigInteger;
import java.util.Optional;
import java.util.regex.Pattern;
import org.opendaylight.yangtools.yang.data.impl.codec.Int16StringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.Int32StringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.Int64StringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.Int8StringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.Uint16StringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.Uint32StringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.Uint64StringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.Uint8StringCodec;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeRestrictedTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;

@Beta
public abstract class AbstractIntegerStringCodec<N extends Number, T extends RangeRestrictedTypeDefinition<T, N>>
extends TypeDefinitionAwareCodec<N, T> {
    private static final Pattern INT_PATTERN = Pattern.compile("[+-]?[1-9][0-9]*$");
    private static final Pattern HEX_PATTERN = Pattern.compile("[+-]?0[xX][0-9a-fA-F]+");
    private static final Pattern OCT_PATTERN = Pattern.compile("[+-]?0[1-7][0-7]*$");
    private static final CharMatcher X_MATCHER = CharMatcher.anyOf((CharSequence)"xX");
    private static final String INCORRECT_LEXICAL_REPRESENTATION = "Incorrect lexical representation of integer value: %s.\nAn integer value can be defined as: \n  - a decimal number,\n  - a hexadecimal number (prefix 0x),%n  - an octal number (prefix 0).\nSigned values are allowed. Spaces between digits are NOT allowed.";
    private final RangeSet<N> rangeConstraints;

    AbstractIntegerStringCodec(Optional<T> typeDefinition, Optional<RangeConstraint<N>> constraint, Class<N> outputClass) {
        super(typeDefinition, outputClass);
        this.rangeConstraints = constraint.map(RangeConstraint::getAllowedRanges).orElse(null);
    }

    public static AbstractIntegerStringCodec<Byte, Int8TypeDefinition> from(Int8TypeDefinition type) {
        return new Int8StringCodec(Optional.of(type));
    }

    public static AbstractIntegerStringCodec<Short, Int16TypeDefinition> from(Int16TypeDefinition type) {
        return new Int16StringCodec(Optional.of(type));
    }

    public static AbstractIntegerStringCodec<Integer, Int32TypeDefinition> from(Int32TypeDefinition type) {
        return new Int32StringCodec(Optional.of(type));
    }

    public static AbstractIntegerStringCodec<Long, Int64TypeDefinition> from(Int64TypeDefinition type) {
        return new Int64StringCodec(Optional.of(type));
    }

    public static AbstractIntegerStringCodec<Short, Uint8TypeDefinition> from(Uint8TypeDefinition type) {
        return new Uint8StringCodec(Optional.of(type));
    }

    public static AbstractIntegerStringCodec<Integer, Uint16TypeDefinition> from(Uint16TypeDefinition type) {
        return new Uint16StringCodec(Optional.of(type));
    }

    public static AbstractIntegerStringCodec<Long, Uint32TypeDefinition> from(Uint32TypeDefinition type) {
        return new Uint32StringCodec(Optional.of(type));
    }

    public static AbstractIntegerStringCodec<BigInteger, Uint64TypeDefinition> from(Uint64TypeDefinition type) {
        return new Uint64StringCodec(Optional.of(type));
    }

    @Override
    public final N deserialize(String stringRepresentation) {
        int base = AbstractIntegerStringCodec.provideBase(stringRepresentation);
        N deserialized = base == 16 ? this.deserialize(AbstractIntegerStringCodec.normalizeHexadecimal(stringRepresentation), base) : this.deserialize(stringRepresentation, base);
        this.validate(deserialized);
        return deserialized;
    }

    abstract N deserialize(String var1, int var2);

    private void validate(N value) {
        if (this.rangeConstraints != null) {
            Preconditions.checkArgument((boolean)this.rangeConstraints.contains((Comparable)value), (String)"Value '%s'  is not in required ranges %s", value, this.rangeConstraints);
        }
    }

    protected static <N extends Number> Optional<RangeConstraint<N>> extractRange(RangeRestrictedTypeDefinition<?, N> type) {
        return type == null ? Optional.empty() : type.getRangeConstraint();
    }

    private static int provideBase(String integer) {
        Preconditions.checkArgument((integer != null ? 1 : 0) != 0, (Object)"String representing integer number cannot be NULL");
        if (integer.length() == 1 && integer.charAt(0) == '0') {
            return 10;
        }
        if (INT_PATTERN.matcher(integer).matches()) {
            return 10;
        }
        if (HEX_PATTERN.matcher(integer).matches()) {
            return 16;
        }
        if (OCT_PATTERN.matcher(integer).matches()) {
            return 8;
        }
        throw new NumberFormatException(String.format(INCORRECT_LEXICAL_REPRESENTATION, integer));
    }

    private static String normalizeHexadecimal(String hexInt) {
        Preconditions.checkArgument((hexInt != null ? 1 : 0) != 0, (Object)"String representing integer number in Hexadecimal format cannot be NULL!");
        return X_MATCHER.removeFrom((CharSequence)hexInt);
    }
}

