/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.rest.doc.util;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;

public final class RestDocgenUtil {
    private static final Map<URI, Map<Optional<Revision>, Module>> NAMESPACE_AND_REVISION_TO_MODULE = new HashMap<URI, Map<Optional<Revision>, Module>>();

    private RestDocgenUtil() {
    }

    public static String resolvePathArgumentsName(SchemaNode node, SchemaContext schemaContext) {
        Iterable schemaPath = node.getPath().getPathTowardsRoot();
        Iterator it = schemaPath.iterator();
        QName nodeQName = (QName)it.next();
        QName parentQName = null;
        if (it.hasNext()) {
            parentQName = (QName)it.next();
        }
        if (RestDocgenUtil.isEqualNamespaceAndRevision(parentQName, nodeQName)) {
            return node.getQName().getLocalName();
        }
        return RestDocgenUtil.resolveFullNameFromNode(node, schemaContext);
    }

    private static synchronized String resolveFullNameFromNode(SchemaNode node, SchemaContext schemaContext) {
        URI namespace = node.getQName().getNamespace();
        Optional revision = node.getQName().getRevision();
        Map revisionToModule = NAMESPACE_AND_REVISION_TO_MODULE.computeIfAbsent(namespace, k -> new HashMap());
        Module module = revisionToModule.computeIfAbsent(revision, k -> schemaContext.findModule(namespace, k).orElse(null));
        if (module != null) {
            return module.getName() + ":" + node.getQName().getLocalName();
        }
        return node.getQName().getLocalName();
    }

    public static String resolveNodesName(SchemaNode node, Module module, SchemaContext schemaContext) {
        if (node.getQName().getNamespace().equals(module.getQNameModule().getNamespace()) && node.getQName().getRevision().equals(module.getQNameModule().getRevision())) {
            return node.getQName().getLocalName();
        }
        return RestDocgenUtil.resolveFullNameFromNode(node, schemaContext);
    }

    private static boolean isEqualNamespaceAndRevision(QName parentQName, QName nodeQName) {
        if (parentQName == null) {
            return nodeQName == null;
        }
        return parentQName.getNamespace().equals(nodeQName.getNamespace()) && parentQName.getRevision().equals(nodeQName.getRevision());
    }
}

