/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.rest.doc.mountpoints;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMMountPointListener;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.netconf.sal.rest.doc.impl.BaseYangSwaggerGenerator;
import org.opendaylight.netconf.sal.rest.doc.swagger.Api;
import org.opendaylight.netconf.sal.rest.doc.swagger.ApiDeclaration;
import org.opendaylight.netconf.sal.rest.doc.swagger.Operation;
import org.opendaylight.netconf.sal.rest.doc.swagger.Resource;
import org.opendaylight.netconf.sal.rest.doc.swagger.ResourceList;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public class MountPointSwagger
implements DOMMountPointListener,
AutoCloseable {
    private static final String DATASTORES_REVISION = "-";
    private static final String DATASTORES_LABEL = "Datastores";
    private final DOMSchemaService globalSchema;
    private final DOMMountPointService mountService;
    private final BaseYangSwaggerGenerator swaggerGenerator;
    private final Map<YangInstanceIdentifier, Long> instanceIdToLongId = new TreeMap<YangInstanceIdentifier, Long>((o1, o2) -> o1.toString().compareToIgnoreCase(o2.toString()));
    private final Map<Long, YangInstanceIdentifier> longIdToInstanceId = new HashMap<Long, YangInstanceIdentifier>();
    private final Object lock = new Object();
    private final AtomicLong idKey = new AtomicLong(0L);
    private ListenerRegistration<DOMMountPointListener> registration;

    public MountPointSwagger(DOMSchemaService globalSchema, DOMMountPointService mountService, BaseYangSwaggerGenerator swaggerGenerator) {
        this.globalSchema = Objects.requireNonNull(globalSchema);
        this.mountService = Objects.requireNonNull(mountService);
        this.swaggerGenerator = Objects.requireNonNull(swaggerGenerator);
    }

    public void init() {
        this.registration = this.mountService.registerProvisionListener((DOMMountPointListener)this);
    }

    @Override
    public void close() {
        if (this.registration != null) {
            this.registration.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getInstanceIdentifiers() {
        HashMap<String, Long> urlToId = new HashMap<String, Long>();
        Object object = this.lock;
        synchronized (object) {
            SchemaContext context = this.globalSchema.getGlobalContext();
            for (Map.Entry<YangInstanceIdentifier, Long> entry : this.instanceIdToLongId.entrySet()) {
                String modName = MountPointSwagger.findModuleName(entry.getKey(), context);
                urlToId.put(this.swaggerGenerator.generateUrlPrefixFromInstanceID(entry.getKey(), modName), entry.getValue());
            }
        }
        return urlToId;
    }

    private static String findModuleName(YangInstanceIdentifier id, SchemaContext context) {
        YangInstanceIdentifier.PathArgument rootQName = (YangInstanceIdentifier.PathArgument)id.getPathArguments().iterator().next();
        for (Module mod : context.getModules()) {
            if (!mod.findDataChildByName(rootQName.getNodeType()).isPresent()) continue;
            return mod.getName();
        }
        return null;
    }

    private String getYangMountUrl(YangInstanceIdentifier key) {
        String modName = MountPointSwagger.findModuleName(key, this.globalSchema.getGlobalContext());
        return this.swaggerGenerator.generateUrlPrefixFromInstanceID(key, modName) + "yang-ext:mount";
    }

    public ResourceList getResourceList(UriInfo uriInfo, Long id) {
        YangInstanceIdentifier iid = this.getInstanceId(id);
        if (iid == null) {
            return null;
        }
        SchemaContext context = this.getSchemaContext(iid);
        if (context == null) {
            return this.swaggerGenerator.createResourceList();
        }
        LinkedList<Resource> resources = new LinkedList<Resource>();
        Resource dataStores = new Resource();
        dataStores.setDescription("Provides methods for accessing the data stores.");
        dataStores.setPath(this.swaggerGenerator.generatePath(uriInfo, DATASTORES_LABEL, DATASTORES_REVISION));
        resources.add(dataStores);
        String urlPrefix = this.getYangMountUrl(iid);
        ResourceList list = this.swaggerGenerator.getResourceListing(uriInfo, context, urlPrefix);
        resources.addAll(list.getApis());
        list.setApis(resources);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private YangInstanceIdentifier getInstanceId(Long id) {
        YangInstanceIdentifier instanceId;
        Object object = this.lock;
        synchronized (object) {
            instanceId = this.longIdToInstanceId.get(id);
        }
        return instanceId;
    }

    private SchemaContext getSchemaContext(YangInstanceIdentifier id) {
        if (id == null) {
            return null;
        }
        Preconditions.checkState((this.mountService != null ? 1 : 0) != 0);
        Optional mountPoint = this.mountService.getMountPoint(id);
        if (!mountPoint.isPresent()) {
            return null;
        }
        SchemaContext context = ((DOMMountPoint)mountPoint.get()).getSchemaContext();
        if (context == null) {
            return null;
        }
        return context;
    }

    public ApiDeclaration getMountPointApi(UriInfo uriInfo, Long id, String module, String revision) {
        YangInstanceIdentifier iid = this.getInstanceId(id);
        SchemaContext context = this.getSchemaContext(iid);
        String urlPrefix = this.getYangMountUrl(iid);
        if (context == null) {
            return null;
        }
        if (DATASTORES_LABEL.equals(module) && DATASTORES_REVISION.equals(revision)) {
            return this.generateDataStoreApiDoc(uriInfo, urlPrefix);
        }
        return this.swaggerGenerator.getApiDeclaration(module, revision, uriInfo, context, urlPrefix);
    }

    private ApiDeclaration generateDataStoreApiDoc(UriInfo uriInfo, String context) {
        LinkedList<Api> apis = new LinkedList<Api>();
        apis.add(this.createGetApi("config", "Queries the config (startup) datastore on the mounted hosted.", context));
        apis.add(this.createGetApi("operational", "Queries the operational (running) datastore on the mounted hosted.", context));
        apis.add(this.createGetApi("operations", "Queries the available operations (RPC calls) on the mounted hosted.", context));
        ApiDeclaration declaration = this.swaggerGenerator.createApiDeclaration(this.swaggerGenerator.createBasePathFromUriInfo(uriInfo));
        declaration.setApis(apis);
        return declaration;
    }

    private Api createGetApi(String datastore, String note, String context) {
        Operation getConfig = new Operation();
        getConfig.setMethod("GET");
        getConfig.setNickname("GET " + datastore);
        getConfig.setNotes(note);
        Api api = new Api();
        api.setPath(this.swaggerGenerator.getDataStorePath(datastore, context).concat(this.swaggerGenerator.getContent(datastore)));
        api.setOperations(Collections.singletonList(getConfig));
        return api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMountPointCreated(YangInstanceIdentifier path) {
        Object object = this.lock;
        synchronized (object) {
            Long idLong = this.idKey.incrementAndGet();
            this.instanceIdToLongId.put(path, idLong);
            this.longIdToInstanceId.put(idLong, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMountPointRemoved(YangInstanceIdentifier path) {
        Object object = this.lock;
        synchronized (object) {
            Long id = this.instanceIdToLongId.remove(path);
            this.longIdToInstanceId.remove(id);
        }
    }
}

