/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.rest.doc.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.mifmif.common.regex.Generex;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.netconf.sal.rest.doc.util.RestDocgenUtil;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraint;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.MandatoryAware;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeRestrictedTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.RevisionAwareXPathImpl;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ModelGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ModelGenerator.class);
    private static final Pattern STRIP_PATTERN = Pattern.compile("\\[[^\\[\\]]*\\]");
    private static final String BASE_64 = "base64";
    private static final String BINARY_ENCODING_KEY = "binaryEncoding";
    private static final String MEDIA_KEY = "media";
    private static final String UNIQUE_ITEMS_KEY = "uniqueItems";
    private static final String MAX_ITEMS = "maxItems";
    private static final String MIN_ITEMS = "minItems";
    private static final String SCHEMA_URL = "http://json-schema.org/draft-04/schema";
    private static final String SCHEMA_KEY = "$schema";
    private static final String MAX_LENGTH_KEY = "maxLength";
    private static final String MIN_LENGTH_KEY = "minLength";
    private static final String REQUIRED_KEY = "required";
    private static final String REF_KEY = "$ref";
    private static final String ITEMS_KEY = "items";
    private static final String TYPE_KEY = "type";
    private static final String PROPERTIES_KEY = "properties";
    private static final String DESCRIPTION_KEY = "description";
    private static final String OBJECT_TYPE = "object";
    private static final String ARRAY_TYPE = "array";
    private static final String ENUM = "enum";
    private static final String ID_KEY = "id";
    private static final String SUB_TYPES_KEY = "subTypes";
    private static final String UNIQUE_EMPTY_IDENTIFIER = "unique_empty_identifier";
    private Module topLevelModule;

    public ObjectNode convertToJsonSchema(Module module, SchemaContext schemaContext) throws IOException {
        ObjectNode models = JsonNodeFactory.instance.objectNode();
        ObjectNode emptyIdentifier = JsonNodeFactory.instance.objectNode();
        models.set(UNIQUE_EMPTY_IDENTIFIER, (JsonNode)emptyIdentifier);
        this.topLevelModule = module;
        this.processModules(module, models, schemaContext);
        this.processContainersAndLists(module, models, schemaContext);
        this.processRPCs(module, models, schemaContext);
        ModelGenerator.processIdentities(module, models);
        return models;
    }

    private void processModules(Module module, ObjectNode models, SchemaContext schemaContext) {
        ModelGenerator.createConcreteModelForPost(models, module.getName() + "_module", this.createPropertiesForPost((DataNodeContainer)module, schemaContext, module.getName()));
    }

    private void processContainersAndLists(Module module, ObjectNode models, SchemaContext schemaContext) throws IOException {
        String moduleName = module.getName();
        for (DataSchemaNode childNode : module.getChildNodes()) {
            if (!(childNode instanceof ContainerSchemaNode) && !(childNode instanceof ListSchemaNode)) continue;
            this.processDataNodeContainer((DataNodeContainer)childNode, moduleName, models, true, schemaContext);
            this.processDataNodeContainer((DataNodeContainer)childNode, moduleName, models, false, schemaContext);
        }
    }

    private void processRPCs(Module module, ObjectNode models, SchemaContext schemaContext) throws IOException {
        Set rpcs = module.getRpcs();
        String moduleName = module.getName();
        for (RpcDefinition rpc : rpcs) {
            ContainerSchemaNode output;
            ContainerSchemaNode input = rpc.getInput();
            if (!input.getChildNodes().isEmpty()) {
                ObjectNode properties = this.processChildren(input.getChildNodes(), moduleName, models, true, schemaContext);
                String filename = "(" + rpc.getQName().getLocalName() + ")input";
                ObjectNode childSchema = ModelGenerator.getSchemaTemplate();
                childSchema.put(TYPE_KEY, OBJECT_TYPE);
                childSchema.set(PROPERTIES_KEY, (JsonNode)properties);
                childSchema.put(ID_KEY, filename);
                models.set(filename, (JsonNode)childSchema);
                this.processTopData(filename, models, (SchemaNode)input);
            }
            if ((output = rpc.getOutput()).getChildNodes().isEmpty()) continue;
            ObjectNode properties = this.processChildren(output.getChildNodes(), moduleName, models, true, schemaContext);
            String filename = "(" + rpc.getQName().getLocalName() + ")output";
            ObjectNode childSchema = ModelGenerator.getSchemaTemplate();
            childSchema.put(TYPE_KEY, OBJECT_TYPE);
            childSchema.set(PROPERTIES_KEY, (JsonNode)properties);
            childSchema.put(ID_KEY, filename);
            models.set(filename, (JsonNode)childSchema);
            this.processTopData(filename, models, (SchemaNode)output);
        }
    }

    private ObjectNode processTopData(String filename, ObjectNode models, SchemaNode schemaNode) {
        ObjectNode items = JsonNodeFactory.instance.objectNode();
        items.put(REF_KEY, filename);
        ObjectNode dataNodeProperties = JsonNodeFactory.instance.objectNode();
        dataNodeProperties.put(TYPE_KEY, schemaNode instanceof ListSchemaNode ? ARRAY_TYPE : OBJECT_TYPE);
        dataNodeProperties.set(ITEMS_KEY, (JsonNode)items);
        ModelGenerator.putIfNonNull(dataNodeProperties, DESCRIPTION_KEY, schemaNode.getDescription().orElse(null));
        ObjectNode properties = JsonNodeFactory.instance.objectNode();
        properties.set(this.topLevelModule.getName() + ":" + schemaNode.getQName().getLocalName(), (JsonNode)dataNodeProperties);
        ObjectNode finalChildSchema = ModelGenerator.getSchemaTemplate();
        finalChildSchema.put(TYPE_KEY, OBJECT_TYPE);
        finalChildSchema.set(PROPERTIES_KEY, (JsonNode)properties);
        finalChildSchema.put(ID_KEY, filename + "-TOP");
        models.set(filename + "-TOP", (JsonNode)finalChildSchema);
        return dataNodeProperties;
    }

    private static void processIdentities(Module module, ObjectNode models) {
        String moduleName = module.getName();
        Set idNodes = module.getIdentities();
        LOG.debug("Processing Identities for module {} . Found {} identity statements", (Object)moduleName, (Object)idNodes.size());
        for (IdentitySchemaNode idNode : idNodes) {
            ObjectNode identityObj = JsonNodeFactory.instance.objectNode();
            String identityName = idNode.getQName().getLocalName();
            LOG.debug("Processing Identity: {}", (Object)identityName);
            identityObj.put(ID_KEY, identityName);
            ModelGenerator.putIfNonNull(identityObj, DESCRIPTION_KEY, idNode.getDescription().orElse(null));
            ObjectNode props = JsonNodeFactory.instance.objectNode();
            if (idNode.getBaseIdentities().isEmpty()) {
                Set derivedIds = idNode.getDerivedIdentities();
                if (derivedIds != null) {
                    ArrayNode subTypes = new ArrayNode(JsonNodeFactory.instance);
                    for (IdentitySchemaNode derivedId : derivedIds) {
                        subTypes.add(derivedId.getQName().getLocalName());
                    }
                    identityObj.set(SUB_TYPES_KEY, (JsonNode)subTypes);
                }
            } else {
                props.put(TYPE_KEY, ((IdentitySchemaNode)idNode.getBaseIdentities().iterator().next()).getQName().getLocalName());
            }
            identityObj.set(PROPERTIES_KEY, (JsonNode)props);
            models.set(identityName, (JsonNode)identityObj);
        }
    }

    private ObjectNode processDataNodeContainer(DataNodeContainer dataNode, String parentName, ObjectNode models, boolean isConfig, SchemaContext schemaContext) throws IOException {
        if (dataNode instanceof ListSchemaNode || dataNode instanceof ContainerSchemaNode) {
            Collection containerChildren = dataNode.getChildNodes();
            String localName = ((SchemaNode)dataNode).getQName().getLocalName();
            ObjectNode properties = this.processChildren(containerChildren, parentName + "/" + localName, models, isConfig, schemaContext);
            String nodeName = parentName + (isConfig ? "(config)" : "(operational)") + localName;
            ObjectNode childSchema = ModelGenerator.getSchemaTemplate();
            childSchema.put(TYPE_KEY, OBJECT_TYPE);
            childSchema.set(PROPERTIES_KEY, (JsonNode)properties);
            childSchema.put(ID_KEY, nodeName);
            models.set(nodeName, (JsonNode)childSchema);
            if (isConfig) {
                ModelGenerator.createConcreteModelForPost(models, localName, this.createPropertiesForPost(dataNode, schemaContext, parentName + "/" + localName));
            }
            return this.processTopData(nodeName, models, (SchemaNode)dataNode);
        }
        return null;
    }

    private static void createConcreteModelForPost(ObjectNode models, String localName, JsonNode properties) {
        String nodePostName = "(config)" + localName + "POST";
        ObjectNode postSchema = ModelGenerator.getSchemaTemplate();
        postSchema.put(TYPE_KEY, OBJECT_TYPE);
        postSchema.put(ID_KEY, nodePostName);
        postSchema.set(PROPERTIES_KEY, properties);
        models.set(nodePostName, (JsonNode)postSchema);
    }

    private JsonNode createPropertiesForPost(DataNodeContainer dataNodeContainer, SchemaContext schemaContext, String parentName) {
        ObjectNode properties = JsonNodeFactory.instance.objectNode();
        for (DataSchemaNode childNode : dataNodeContainer.getChildNodes()) {
            if (childNode instanceof ListSchemaNode || childNode instanceof ContainerSchemaNode) {
                ObjectNode items = JsonNodeFactory.instance.objectNode();
                items.put(REF_KEY, parentName + "(config)" + childNode.getQName().getLocalName());
                ObjectNode property = JsonNodeFactory.instance.objectNode();
                property.put(TYPE_KEY, childNode instanceof ListSchemaNode ? ARRAY_TYPE : OBJECT_TYPE);
                property.set(ITEMS_KEY, (JsonNode)items);
                properties.set(childNode.getQName().getLocalName(), (JsonNode)property);
                continue;
            }
            if (!(childNode instanceof LeafSchemaNode)) continue;
            ObjectNode property = this.processLeafNode((LeafSchemaNode)childNode, schemaContext);
            properties.set(childNode.getQName().getLocalName(), (JsonNode)property);
        }
        return properties;
    }

    private ObjectNode processChildren(Iterable<DataSchemaNode> nodes, String parentName, ObjectNode models, boolean isConfig, SchemaContext schemaContext) throws IOException {
        ObjectNode properties = JsonNodeFactory.instance.objectNode();
        for (DataSchemaNode node : nodes) {
            ObjectNode property;
            if (node.isConfiguration() != isConfig) continue;
            String name = RestDocgenUtil.resolveNodesName((SchemaNode)node, this.topLevelModule, schemaContext);
            if (node instanceof LeafSchemaNode) {
                property = this.processLeafNode((LeafSchemaNode)node, schemaContext);
            } else if (node instanceof ListSchemaNode) {
                property = this.processDataNodeContainer((DataNodeContainer)((ListSchemaNode)node), parentName, models, isConfig, schemaContext);
            } else if (node instanceof LeafListSchemaNode) {
                property = this.processLeafListNode((LeafListSchemaNode)node, schemaContext);
            } else {
                if (node instanceof ChoiceSchemaNode) {
                    if (!((ChoiceSchemaNode)node).getCases().values().iterator().hasNext()) continue;
                    this.processChoiceNode(((CaseSchemaNode)((ChoiceSchemaNode)node).getCases().values().iterator().next()).getChildNodes(), parentName, models, schemaContext, isConfig, properties);
                    continue;
                }
                if (node instanceof AnyXmlSchemaNode) {
                    property = ModelGenerator.processAnyXMLNode((AnyXmlSchemaNode)node);
                } else if (node instanceof ContainerSchemaNode) {
                    property = this.processDataNodeContainer((DataNodeContainer)((ContainerSchemaNode)node), parentName, models, isConfig, schemaContext);
                } else {
                    throw new IllegalArgumentException("Unknown DataSchemaNode type: " + node.getClass());
                }
            }
            ModelGenerator.putIfNonNull(property, DESCRIPTION_KEY, node.getDescription().orElse(null));
            properties.set(this.topLevelModule.getName() + ":" + name, (JsonNode)property);
        }
        return properties;
    }

    private ObjectNode processLeafListNode(LeafListSchemaNode listNode, SchemaContext schemaContext) {
        int max;
        ObjectNode props = JsonNodeFactory.instance.objectNode();
        props.put(TYPE_KEY, ARRAY_TYPE);
        ObjectNode itemsVal = JsonNodeFactory.instance.objectNode();
        Optional optConstraint = listNode.getElementCountConstraint();
        if (optConstraint.isPresent()) {
            Integer constraintMax = ((ElementCountConstraint)optConstraint.get()).getMaxElements();
            max = constraintMax == null ? 2 : constraintMax;
            ModelGenerator.processElementCount((ElementCountConstraint)optConstraint.get(), props);
        } else {
            max = 2;
        }
        if (max >= 2) {
            this.processTypeDef(listNode.getType(), (DataSchemaNode)listNode, itemsVal, schemaContext);
            this.processTypeDef(listNode.getType(), (DataSchemaNode)listNode, itemsVal, schemaContext);
        } else {
            this.processTypeDef(listNode.getType(), (DataSchemaNode)listNode, itemsVal, schemaContext);
        }
        props.set(ITEMS_KEY, (JsonNode)itemsVal);
        return props;
    }

    private void processChoiceNode(Iterable<DataSchemaNode> nodes, String moduleName, ObjectNode models, SchemaContext schemaContext, boolean isConfig, ObjectNode properties) throws IOException {
        for (DataSchemaNode node : nodes) {
            ObjectNode property;
            String name = RestDocgenUtil.resolveNodesName((SchemaNode)node, this.topLevelModule, schemaContext);
            if (node instanceof LeafSchemaNode) {
                property = this.processLeafNode((LeafSchemaNode)node, schemaContext);
            } else if (node instanceof ListSchemaNode) {
                property = this.processDataNodeContainer((DataNodeContainer)((ListSchemaNode)node), moduleName, models, isConfig, schemaContext);
            } else if (node instanceof LeafListSchemaNode) {
                property = this.processLeafListNode((LeafListSchemaNode)node, schemaContext);
            } else {
                if (node instanceof ChoiceSchemaNode) {
                    if (!((ChoiceSchemaNode)node).getCases().values().iterator().hasNext()) continue;
                    this.processChoiceNode(((CaseSchemaNode)((ChoiceSchemaNode)node).getCases().values().iterator().next()).getChildNodes(), moduleName, models, schemaContext, isConfig, properties);
                    continue;
                }
                if (node instanceof AnyXmlSchemaNode) {
                    property = ModelGenerator.processAnyXMLNode((AnyXmlSchemaNode)node);
                } else if (node instanceof ContainerSchemaNode) {
                    property = this.processDataNodeContainer((DataNodeContainer)((ContainerSchemaNode)node), moduleName, models, isConfig, schemaContext);
                } else {
                    throw new IllegalArgumentException("Unknown DataSchemaNode type: " + node.getClass());
                }
            }
            ModelGenerator.putIfNonNull(property, DESCRIPTION_KEY, node.getDescription().orElse(null));
            properties.set(name, (JsonNode)property);
        }
    }

    private static void processElementCount(ElementCountConstraint constraint, ObjectNode props) {
        Integer maxElements;
        Integer minElements = constraint.getMinElements();
        if (minElements != null) {
            props.put(MIN_ITEMS, minElements);
        }
        if ((maxElements = constraint.getMaxElements()) != null) {
            props.put(MAX_ITEMS, maxElements);
        }
    }

    private static void processMandatory(MandatoryAware node, ObjectNode props) {
        props.put(REQUIRED_KEY, node.isMandatory());
    }

    private ObjectNode processLeafNode(LeafSchemaNode leafNode, SchemaContext schemaContext) {
        ObjectNode property = JsonNodeFactory.instance.objectNode();
        String leafDescription = leafNode.getDescription().orElse(null);
        ModelGenerator.putIfNonNull(property, DESCRIPTION_KEY, leafDescription);
        ModelGenerator.processMandatory((MandatoryAware)leafNode, property);
        this.processTypeDef(leafNode.getType(), (DataSchemaNode)leafNode, property, schemaContext);
        return property;
    }

    private static ObjectNode processAnyXMLNode(AnyXmlSchemaNode leafNode) {
        ObjectNode property = JsonNodeFactory.instance.objectNode();
        String leafDescription = leafNode.getDescription().orElse(null);
        ModelGenerator.putIfNonNull(property, DESCRIPTION_KEY, leafDescription);
        ModelGenerator.processMandatory((MandatoryAware)leafNode, property);
        String localName = leafNode.getQName().getLocalName();
        property.put(TYPE_KEY, "example of anyxml " + localName);
        return property;
    }

    private String processTypeDef(TypeDefinition<?> leafTypeDef, DataSchemaNode node, ObjectNode property, SchemaContext schemaContext) {
        String jsonType;
        if (leafTypeDef.getDefaultValue() == null) {
            if (leafTypeDef instanceof BinaryTypeDefinition) {
                jsonType = ModelGenerator.processBinaryType(property);
            } else if (leafTypeDef instanceof BitsTypeDefinition) {
                jsonType = ModelGenerator.processBitsType((BitsTypeDefinition)leafTypeDef, property);
            } else if (leafTypeDef instanceof EnumTypeDefinition) {
                jsonType = ModelGenerator.processEnumType((EnumTypeDefinition)leafTypeDef, property);
            } else if (leafTypeDef instanceof IdentityrefTypeDefinition) {
                String name = this.topLevelModule.getName();
                jsonType = name + ":" + ((IdentitySchemaNode)((IdentityrefTypeDefinition)leafTypeDef).getIdentities().iterator().next()).getQName().getLocalName();
            } else if (leafTypeDef instanceof StringTypeDefinition) {
                jsonType = ModelGenerator.processStringType(leafTypeDef, property, node.getQName().getLocalName());
            } else if (leafTypeDef instanceof UnionTypeDefinition) {
                jsonType = this.processUnionType((UnionTypeDefinition)leafTypeDef, property, schemaContext, node);
            } else if (leafTypeDef instanceof EmptyTypeDefinition) {
                jsonType = UNIQUE_EMPTY_IDENTIFIER;
            } else {
                if (leafTypeDef instanceof LeafrefTypeDefinition) {
                    return this.processLeafRef(node, property, schemaContext, leafTypeDef);
                }
                if (leafTypeDef instanceof BooleanTypeDefinition) {
                    jsonType = "true";
                } else if (leafTypeDef instanceof RangeRestrictedTypeDefinition) {
                    Number maybeLower = ((RangeRestrictedTypeDefinition)leafTypeDef).getRangeConstraint().map(RangeConstraint::getAllowedRanges).map(RangeSet::span).map(Range::lowerEndpoint).orElse(null);
                    jsonType = String.valueOf(maybeLower);
                } else {
                    jsonType = OBJECT_TYPE;
                }
            }
        } else {
            jsonType = String.valueOf(leafTypeDef.getDefaultValue());
        }
        ModelGenerator.putIfNonNull(property, TYPE_KEY, jsonType);
        return jsonType;
    }

    private String processLeafRef(DataSchemaNode node, ObjectNode property, SchemaContext schemaContext, TypeDefinition<?> leafTypeDef) {
        SchemaNode schemaNode;
        RevisionAwareXPath xpath = ((LeafrefTypeDefinition)leafTypeDef).getPathStatement();
        String xPathString = STRIP_PATTERN.matcher(xpath.toString()).replaceAll("");
        if ((xpath = new RevisionAwareXPathImpl(xPathString, xpath.isAbsolute())).isAbsolute()) {
            Module module = ModelGenerator.findModule(schemaContext, leafTypeDef.getQName());
            schemaNode = SchemaContextUtil.findDataSchemaNode((SchemaContext)schemaContext, (Module)module, (RevisionAwareXPath)xpath);
        } else {
            Module module = ModelGenerator.findModule(schemaContext, node.getQName());
            schemaNode = SchemaContextUtil.findDataSchemaNodeForRelativeXPath((SchemaContext)schemaContext, (Module)module, (SchemaNode)node, (RevisionAwareXPath)xpath);
        }
        return this.processTypeDef(((TypedDataSchemaNode)schemaNode).getType(), (DataSchemaNode)schemaNode, property, schemaContext);
    }

    private static Module findModule(SchemaContext schemaContext, QName qualifiedName) {
        return schemaContext.findModule(qualifiedName.getNamespace(), qualifiedName.getRevision()).orElse(null);
    }

    private static String processBinaryType(ObjectNode property) {
        ObjectNode media = JsonNodeFactory.instance.objectNode();
        media.put(BINARY_ENCODING_KEY, BASE_64);
        property.set(MEDIA_KEY, (JsonNode)media);
        return "bin1 bin2";
    }

    private static String processEnumType(EnumTypeDefinition enumLeafType, ObjectNode property) {
        List enumPairs = enumLeafType.getValues();
        ArrayNode enumNames = new ArrayNode(JsonNodeFactory.instance);
        for (EnumTypeDefinition.EnumPair enumPair : enumPairs) {
            enumNames.add((JsonNode)new TextNode(enumPair.getName()));
        }
        property.set(ENUM, (JsonNode)enumNames);
        return ((EnumTypeDefinition.EnumPair)enumLeafType.getValues().iterator().next()).getName();
    }

    private static String processBitsType(BitsTypeDefinition bitsType, ObjectNode property) {
        property.put(MIN_ITEMS, 0);
        property.put(UNIQUE_ITEMS_KEY, true);
        ArrayNode enumNames = new ArrayNode(JsonNodeFactory.instance);
        List bits = bitsType.getBits();
        for (BitsTypeDefinition.Bit bit : bits) {
            enumNames.add((JsonNode)new TextNode(bit.getName()));
        }
        property.set(ENUM, (JsonNode)enumNames);
        return enumNames.iterator().next() + " " + enumNames.get(enumNames.size() - 1);
    }

    private static String processStringType(TypeDefinition<?> stringType, ObjectNode property, String nodeName) {
        StringTypeDefinition type = (StringTypeDefinition)stringType;
        Optional lengthConstraints = ((StringTypeDefinition)stringType).getLengthConstraint();
        while (!lengthConstraints.isPresent() && type.getBaseType() != null) {
            type = (StringTypeDefinition)type.getBaseType();
            lengthConstraints = type.getLengthConstraint();
        }
        if (lengthConstraints.isPresent()) {
            Range range = ((LengthConstraint)lengthConstraints.get()).getAllowedRanges().span();
            ModelGenerator.putIfNonNull(property, MIN_LENGTH_KEY, (Number)((Object)range.lowerEndpoint()));
            ModelGenerator.putIfNonNull(property, MAX_LENGTH_KEY, (Number)((Object)range.upperEndpoint()));
        }
        if (type.getPatternConstraints().iterator().hasNext()) {
            PatternConstraint pattern = (PatternConstraint)type.getPatternConstraints().iterator().next();
            String regex = pattern.getJavaPatternString();
            regex = regex.substring(1, regex.length() - 1);
            Generex generex = new Generex(regex);
            return generex.random();
        }
        return "Some " + nodeName;
    }

    private String processUnionType(UnionTypeDefinition unionType, ObjectNode property, SchemaContext schemaContext, DataSchemaNode node) {
        ArrayNode unionNames = new ArrayNode(JsonNodeFactory.instance);
        for (TypeDefinition typeDef : unionType.getTypes()) {
            unionNames.add(this.processTypeDef(typeDef, node, property, schemaContext));
        }
        property.set(ENUM, (JsonNode)unionNames);
        return ((JsonNode)unionNames.iterator().next()).asText();
    }

    private static ObjectNode getSchemaTemplate() {
        ObjectNode schemaJSON = JsonNodeFactory.instance.objectNode();
        schemaJSON.put(SCHEMA_KEY, SCHEMA_URL);
        return schemaJSON;
    }

    private static void putIfNonNull(ObjectNode property, String key, Number number) {
        if (key != null && number != null) {
            if (number instanceof Double) {
                property.put(key, (Double)number);
            } else if (number instanceof Float) {
                property.put(key, (Float)number);
            } else if (number instanceof Integer) {
                property.put(key, (Integer)number);
            } else if (number instanceof Short) {
                property.put(key, (Short)number);
            } else if (number instanceof Long) {
                property.put(key, (Long)number);
            }
        }
    }

    private static void putIfNonNull(ObjectNode property, String key, String value) {
        if (key != null && value != null) {
            property.put(key, value);
        }
    }
}

