/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.rest.doc.impl;

import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.netconf.sal.rest.doc.api.ApiDocService;
import org.opendaylight.netconf.sal.rest.doc.impl.ApiDocGeneratorDraftO2;
import org.opendaylight.netconf.sal.rest.doc.impl.ApiDocGeneratorRFC8040;
import org.opendaylight.netconf.sal.rest.doc.impl.MountPointSwaggerGeneratorDraft02;
import org.opendaylight.netconf.sal.rest.doc.impl.MountPointSwaggerGeneratorRFC8040;
import org.opendaylight.netconf.sal.rest.doc.mountpoints.MountPointSwagger;
import org.opendaylight.netconf.sal.rest.doc.swagger.ApiDeclaration;
import org.opendaylight.netconf.sal.rest.doc.swagger.MountPointInstance;
import org.opendaylight.netconf.sal.rest.doc.swagger.ResourceList;

public class ApiDocServiceImpl
implements ApiDocService {
    private final MountPointSwagger mountPointSwaggerDraft02;
    private final MountPointSwagger mountPointSwaggerRFC8040;
    private final ApiDocGeneratorDraftO2 apiDocGeneratorDraft02;
    private final ApiDocGeneratorRFC8040 apiDocGeneratorRFC8040;

    public ApiDocServiceImpl(MountPointSwaggerGeneratorDraft02 mountPointSwaggerGeneratorDraft02, MountPointSwaggerGeneratorRFC8040 mountPointSwaggerGeneratorRFC8040, ApiDocGeneratorDraftO2 apiDocGeneratorDraft02, ApiDocGeneratorRFC8040 apiDocGeneratorRFC8040) {
        this.mountPointSwaggerDraft02 = Objects.requireNonNull(mountPointSwaggerGeneratorDraft02).getMountPointSwagger();
        this.mountPointSwaggerRFC8040 = Objects.requireNonNull(mountPointSwaggerGeneratorRFC8040).getMountPointSwagger();
        this.apiDocGeneratorDraft02 = Objects.requireNonNull(apiDocGeneratorDraft02);
        this.apiDocGeneratorRFC8040 = Objects.requireNonNull(apiDocGeneratorRFC8040);
    }

    @Override
    public synchronized Response getRootDoc(UriInfo uriInfo) {
        ResourceList rootDoc = ApiDocServiceImpl.isNew(uriInfo) ? this.apiDocGeneratorRFC8040.getResourceListing(uriInfo) : this.apiDocGeneratorDraft02.getResourceListing(uriInfo);
        return Response.ok((Object)rootDoc).build();
    }

    @Override
    public synchronized Response getDocByModule(String module, String revision, UriInfo uriInfo) {
        ApiDeclaration doc = ApiDocServiceImpl.isNew(uriInfo) ? this.apiDocGeneratorRFC8040.getApiDeclaration(module, revision, uriInfo) : this.apiDocGeneratorDraft02.getApiDeclaration(module, revision, uriInfo);
        return Response.ok((Object)doc).build();
    }

    @Override
    public synchronized Response getApiExplorer(UriInfo uriInfo) {
        return Response.seeOther((URI)uriInfo.getBaseUriBuilder().path("../explorer/index.html").build(new Object[0])).build();
    }

    @Override
    public synchronized Response getListOfMounts(UriInfo uriInfo) {
        MountPointSwagger mountPointSwagger = ApiDocServiceImpl.isNew(uriInfo) ? this.mountPointSwaggerRFC8040 : this.mountPointSwaggerDraft02;
        List entity = mountPointSwagger.getInstanceIdentifiers().entrySet().stream().map(MountPointInstance::new).collect(Collectors.toList());
        return Response.ok(entity).build();
    }

    @Override
    public synchronized Response getMountRootDoc(String instanceNum, UriInfo uriInfo) {
        ResourceList resourceList = ApiDocServiceImpl.isNew(uriInfo) ? this.mountPointSwaggerRFC8040.getResourceList(uriInfo, Long.parseLong(instanceNum)) : this.mountPointSwaggerDraft02.getResourceList(uriInfo, Long.parseLong(instanceNum));
        return Response.ok((Object)resourceList).build();
    }

    @Override
    public synchronized Response getMountDocByModule(String instanceNum, String module, String revision, UriInfo uriInfo) {
        ApiDeclaration api = ApiDocServiceImpl.isNew(uriInfo) ? this.mountPointSwaggerRFC8040.getMountPointApi(uriInfo, Long.parseLong(instanceNum), module, revision) : this.mountPointSwaggerDraft02.getMountPointApi(uriInfo, Long.parseLong(instanceNum), module, revision);
        return Response.ok((Object)api).build();
    }

    private static boolean isNew(UriInfo uriInfo) {
        return uriInfo.getBaseUri().toString().contains("/18/");
    }
}

