/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ipv6;

import com.googlecode.ipv6.IPv6Address;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class IPv6AddressHelpers {
    private static final Pattern DOT_DELIM = Pattern.compile("\\.");

    static long[] parseStringArrayIntoLongArray(String[] strings) {
        long[] longs = new long[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            longs[i] = Long.parseLong(strings[i], 16);
        }
        return longs;
    }

    static void validateLongs(long[] longs) {
        if (longs.length != 8) {
            throw new IllegalArgumentException("an IPv6 address should contain 8 shorts [" + Arrays.toString(longs) + "]");
        }
        for (long l : longs) {
            if (l < 0L) {
                throw new IllegalArgumentException("each element should be positive [" + Arrays.toString(longs) + "]");
            }
            if (l <= 65535L) continue;
            throw new IllegalArgumentException("each element should be less than 0xFFFF [" + Arrays.toString(longs) + "]");
        }
    }

    static IPv6Address mergeLongArrayIntoIPv6Address(long[] longs) {
        long high = 0L;
        long low = 0L;
        for (int i = 0; i < longs.length; ++i) {
            if (IPv6AddressHelpers.inHighRange(i)) {
                high |= longs[i] << (longs.length - i - 1) * 16;
                continue;
            }
            low |= longs[i] << (longs.length - i - 1) * 16;
        }
        return new IPv6Address(high, low);
    }

    static boolean inHighRange(int shortNumber) {
        return shortNumber >= 0 && shortNumber < 4;
    }

    static String expandShortNotation(String string) {
        if (!string.contains("::")) {
            return string;
        }
        if (string.equals("::")) {
            return IPv6AddressHelpers.generateZeroes(8);
        }
        int numberOfColons = IPv6AddressHelpers.countOccurrences(string, ':');
        if (string.startsWith("::")) {
            return string.replace("::", IPv6AddressHelpers.generateZeroes(9 - numberOfColons));
        }
        if (string.endsWith("::")) {
            return string.replace("::", ":" + IPv6AddressHelpers.generateZeroes(9 - numberOfColons));
        }
        return string.replace("::", ":" + IPv6AddressHelpers.generateZeroes(8 - numberOfColons));
    }

    static String rewriteIPv4MappedNotation(String string) {
        if (!string.contains(".")) {
            return string;
        }
        int lastColon = string.lastIndexOf(":");
        String firstPart = string.substring(0, lastColon + 1);
        String mappedIPv4Part = string.substring(lastColon + 1);
        if (mappedIPv4Part.contains(".")) {
            String[] dotSplits = DOT_DELIM.split(mappedIPv4Part);
            if (dotSplits.length != 4) {
                throw new IllegalArgumentException(String.format("can not parse [%s]", string));
            }
            StringBuilder rewrittenString = new StringBuilder();
            rewrittenString.append(firstPart);
            int byteZero = Integer.parseInt(dotSplits[0]);
            int byteOne = Integer.parseInt(dotSplits[1]);
            int byteTwo = Integer.parseInt(dotSplits[2]);
            int byteThree = Integer.parseInt(dotSplits[3]);
            rewrittenString.append(String.format("%02x", byteZero));
            rewrittenString.append(String.format("%02x", byteOne));
            rewrittenString.append(":");
            rewrittenString.append(String.format("%02x", byteTwo));
            rewrittenString.append(String.format("%02x", byteThree));
            return rewrittenString.toString();
        }
        throw new IllegalArgumentException(String.format("can not parse [%s]", string));
    }

    public static int countOccurrences(String haystack, char needle) {
        int count = 0;
        for (int i = 0; i < haystack.length(); ++i) {
            if (haystack.charAt(i) != needle) continue;
            ++count;
        }
        return count;
    }

    public static String generateZeroes(int number) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < number; ++i) {
            builder.append("0:");
        }
        return builder.toString();
    }

    static boolean isLessThanUnsigned(long a, long b) {
        return a < b ^ a < 0L != b < 0L;
    }

    static byte[] prefixWithZeroBytes(byte[] original, int newSize) {
        byte[] target = new byte[newSize];
        System.arraycopy(original, 0, target, newSize - original.length, original.length);
        return target;
    }
}

