/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.module;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.CommonLeafs;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.SchemaLeaf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.module.Submodule;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.module.SubmoduleKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangIdentifier;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SubmoduleBuilder
implements Builder<Submodule> {
    private YangIdentifier _name;
    private CommonLeafs.Revision _revision;
    private Uri _schema;
    private SubmoduleKey key;
    Map<Class<? extends Augmentation<Submodule>>, Augmentation<Submodule>> augmentation = Collections.emptyMap();

    public SubmoduleBuilder() {
    }

    public SubmoduleBuilder(SchemaLeaf arg) {
        this._schema = arg.getSchema();
    }

    public SubmoduleBuilder(CommonLeafs arg) {
        this._name = arg.getName();
        this._revision = arg.getRevision();
    }

    public SubmoduleBuilder(Submodule base) {
        Map aug;
        this.key = base.key();
        this._name = base.getName();
        this._revision = base.getRevision();
        this._schema = base.getSchema();
        if (base instanceof SubmoduleImpl) {
            SubmoduleImpl impl = (SubmoduleImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Submodule>>, Augmentation<Submodule>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Submodule>>, Augmentation<Submodule>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CommonLeafs) {
            this._name = ((CommonLeafs)arg).getName();
            this._revision = ((CommonLeafs)arg).getRevision();
            isValidArg = true;
        }
        if (arg instanceof SchemaLeaf) {
            this._schema = ((SchemaLeaf)arg).getSchema();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.CommonLeafs, org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.SchemaLeaf]");
    }

    public SubmoduleKey key() {
        return this.key;
    }

    public YangIdentifier getName() {
        return this._name;
    }

    public CommonLeafs.Revision getRevision() {
        return this._revision;
    }

    public Uri getSchema() {
        return this._schema;
    }

    public <E$$ extends Augmentation<Submodule>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public SubmoduleBuilder withKey(SubmoduleKey key) {
        this.key = key;
        return this;
    }

    public SubmoduleBuilder setName(YangIdentifier value) {
        this._name = value;
        return this;
    }

    public SubmoduleBuilder setRevision(CommonLeafs.Revision value) {
        this._revision = value;
        return this;
    }

    public SubmoduleBuilder setSchema(Uri value) {
        this._schema = value;
        return this;
    }

    public SubmoduleBuilder addAugmentation(Class<? extends Augmentation<Submodule>> augmentationType, Augmentation<Submodule> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Submodule>>, Augmentation<Submodule>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SubmoduleBuilder removeAugmentation(Class<? extends Augmentation<Submodule>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Submodule build() {
        return new SubmoduleImpl(this);
    }

    private static final class SubmoduleImpl
    implements Submodule {
        private final YangIdentifier _name;
        private final CommonLeafs.Revision _revision;
        private final Uri _schema;
        private final SubmoduleKey key;
        private Map<Class<? extends Augmentation<Submodule>>, Augmentation<Submodule>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        SubmoduleImpl(SubmoduleBuilder base) {
            this.key = base.key() != null ? base.key() : new SubmoduleKey(base.getName(), base.getRevision());
            this._name = this.key.getName();
            this._revision = this.key.getRevision();
            this._schema = base.getSchema();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Submodule> getImplementedInterface() {
            return Submodule.class;
        }

        @Override
        public SubmoduleKey key() {
            return this.key;
        }

        @Override
        public YangIdentifier getName() {
            return this._name;
        }

        @Override
        public CommonLeafs.Revision getRevision() {
            return this._revision;
        }

        @Override
        public Uri getSchema() {
            return this._schema;
        }

        public <E$$ extends Augmentation<Submodule>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._revision);
            result = 31 * result + Objects.hashCode(this._schema);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Submodule.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Submodule other = (Submodule)obj;
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._revision, other.getRevision())) {
                return false;
            }
            if (!Objects.equals(this._schema, other.getSchema())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SubmoduleImpl otherImpl = (SubmoduleImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Submodule>>, Augmentation<Submodule>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Submodule");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)this._name);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_revision", (Object)this._revision);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_schema", (Object)this._schema);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

