/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.eos.binding.dom.adapter;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.eos.binding.api.Entity;
import org.opendaylight.mdsal.eos.binding.api.EntityOwnershipCandidateRegistration;
import org.opendaylight.mdsal.eos.binding.api.EntityOwnershipListener;
import org.opendaylight.mdsal.eos.binding.api.EntityOwnershipListenerRegistration;
import org.opendaylight.mdsal.eos.binding.api.EntityOwnershipService;
import org.opendaylight.mdsal.eos.binding.dom.adapter.BindingEntityOwnershipCandidateRegistration;
import org.opendaylight.mdsal.eos.binding.dom.adapter.BindingEntityOwnershipListenerRegistration;
import org.opendaylight.mdsal.eos.binding.dom.adapter.DOMEntityOwnershipListenerAdapter;
import org.opendaylight.mdsal.eos.common.api.CandidateAlreadyRegisteredException;
import org.opendaylight.mdsal.eos.common.api.EntityOwnershipState;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListener;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipService;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class BindingDOMEntityOwnershipServiceAdapter
implements EntityOwnershipService,
AutoCloseable {
    private final @NonNull DOMEntityOwnershipService domService;
    private final @NonNull BindingNormalizedNodeSerializer conversionCodec;

    public BindingDOMEntityOwnershipServiceAdapter(@NonNull DOMEntityOwnershipService domService, @NonNull BindingNormalizedNodeSerializer conversionCodec) {
        this.domService = Objects.requireNonNull(domService);
        this.conversionCodec = Objects.requireNonNull(conversionCodec);
    }

    public EntityOwnershipCandidateRegistration registerCandidate(Entity entity) throws CandidateAlreadyRegisteredException {
        return new BindingEntityOwnershipCandidateRegistration(this.domService.registerCandidate(this.toDOMEntity(entity)), entity);
    }

    public EntityOwnershipListenerRegistration registerListener(String entityType, EntityOwnershipListener listener) {
        return new BindingEntityOwnershipListenerRegistration(entityType, listener, this.domService.registerListener(entityType, (DOMEntityOwnershipListener)new DOMEntityOwnershipListenerAdapter(listener, this.conversionCodec)));
    }

    public Optional<EntityOwnershipState> getOwnershipState(Entity forEntity) {
        return this.domService.getOwnershipState(this.toDOMEntity(forEntity));
    }

    public boolean isCandidateRegistered(Entity forEntity) {
        return this.domService.isCandidateRegistered(this.toDOMEntity(forEntity));
    }

    private @NonNull DOMEntity toDOMEntity(Entity entity) {
        return new DOMEntity(entity.getType(), this.conversionCodec.toYangInstanceIdentifier((InstanceIdentifier)entity.getIdentifier()));
    }

    @Override
    public void close() {
    }
}

