/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.util.HashCodeBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.ChoiceIn;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataRoot;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifierBuilderImpl;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifierV3;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;

public class InstanceIdentifier<T extends DataObject>
implements Path<InstanceIdentifier<? extends DataObject>>,
Immutable,
Serializable {
    private static final long serialVersionUID = 3L;
    final Iterable<PathArgument> pathArguments;
    private final Class<T> targetType;
    private final boolean wildcarded;
    private final int hash;

    InstanceIdentifier(Class<T> type, Iterable<PathArgument> pathArguments, boolean wildcarded, int hash) {
        this.pathArguments = Objects.requireNonNull(pathArguments);
        this.targetType = Objects.requireNonNull(type);
        this.wildcarded = wildcarded;
        this.hash = hash;
    }

    public final Class<T> getTargetType() {
        return this.targetType;
    }

    public final Iterable<PathArgument> getPathArguments() {
        return Iterables.unmodifiableIterable(this.pathArguments);
    }

    public final boolean isWildcarded() {
        return this.wildcarded;
    }

    public final int hashCode() {
        return this.hash;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstanceIdentifier other = (InstanceIdentifier)obj;
        if (this.pathArguments == other.pathArguments) {
            return true;
        }
        if (this.hash != other.hash) {
            return false;
        }
        if (this.wildcarded != other.wildcarded) {
            return false;
        }
        if (this.targetType != other.targetType) {
            return false;
        }
        if (this.fastNonEqual(other)) {
            return false;
        }
        return Iterables.elementsEqual(this.pathArguments, other.pathArguments);
    }

    protected boolean fastNonEqual(InstanceIdentifier<?> other) {
        return false;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("targetType", this.targetType).add("path", (Object)Iterables.toString(this.pathArguments));
    }

    public final <I extends DataObject> InstanceIdentifier<I> firstIdentifierOf(Class<I> type) {
        int count = 1;
        for (PathArgument a : this.pathArguments) {
            if (type.equals(a.getType())) {
                InstanceIdentifier<?> ret = InstanceIdentifier.internalCreate(Iterables.limit(this.pathArguments, (int)count));
                return ret;
            }
            ++count;
        }
        return null;
    }

    public final <N extends Identifiable<K> & DataObject, K extends Identifier<N>> K firstKeyOf(Class<N> listItem) {
        for (PathArgument i : this.pathArguments) {
            if (!listItem.equals(i.getType())) continue;
            Object ret = ((IdentifiableItem)i).getKey();
            return (K)ret;
        }
        return null;
    }

    public final boolean contains(InstanceIdentifier<? extends DataObject> other) {
        Objects.requireNonNull(other, "other should not be null");
        Iterator<PathArgument> lit = this.pathArguments.iterator();
        Iterator<PathArgument> oit = other.pathArguments.iterator();
        while (lit.hasNext()) {
            if (!oit.hasNext()) {
                return false;
            }
            if (lit.next().equals(oit.next())) continue;
            return false;
        }
        return true;
    }

    public final boolean containsWildcarded(InstanceIdentifier<?> other) {
        Objects.requireNonNull(other, "other should not be null");
        Iterator<PathArgument> lit = this.pathArguments.iterator();
        Iterator<PathArgument> oit = other.pathArguments.iterator();
        while (lit.hasNext()) {
            if (!oit.hasNext()) {
                return false;
            }
            PathArgument la = lit.next();
            PathArgument oa = oit.next();
            if (!la.getType().equals(oa.getType())) {
                return false;
            }
            if (!(la instanceof IdentifiableItem) || !(oa instanceof IdentifiableItem) || la.equals(oa)) continue;
            return false;
        }
        return true;
    }

    private <N extends DataObject> InstanceIdentifier<N> childIdentifier(AbstractPathArgument<N> arg) {
        return InstanceIdentifier.trustedCreate(arg, Iterables.concat(this.pathArguments, Collections.singleton(arg)), HashCodeBuilder.nextHashCode((int)this.hash, arg), this.isWildcarded());
    }

    public final <N extends ChildOf<? super T>> InstanceIdentifier<N> child(Class<N> container) {
        return this.childIdentifier(Item.of(container));
    }

    public final <N extends Identifiable<K> & ChildOf<? super T>, K extends Identifier<N>> KeyedInstanceIdentifier<N, K> child(Class<N> listItem, K listKey) {
        return (KeyedInstanceIdentifier)this.childIdentifier(IdentifiableItem.of(listItem, listKey));
    }

    public final <C extends ChoiceIn<? super T> & DataObject, N extends ChildOf<? super C>> InstanceIdentifier<N> child(Class<C> caze, Class<N> container) {
        return this.childIdentifier(Item.of(caze, container));
    }

    public final <C extends ChoiceIn<? super T> & DataObject, K extends Identifier<N>, N extends Identifiable<K> & ChildOf<? super C>> KeyedInstanceIdentifier<N, K> child(Class<C> caze, Class<N> listItem, K listKey) {
        return (KeyedInstanceIdentifier)this.childIdentifier(IdentifiableItem.of(caze, listItem, listKey));
    }

    public final <N extends DataObject & Augmentation<? super T>> InstanceIdentifier<N> augmentation(Class<N> container) {
        return this.childIdentifier(Item.of(container));
    }

    public InstanceIdentifierBuilder<T> builder() {
        return new InstanceIdentifierBuilderImpl(Item.of(this.targetType), this.pathArguments, this.hash, this.isWildcarded());
    }

    public static <T extends ChildOf<? extends DataRoot>> InstanceIdentifierBuilder<T> builder(Class<T> container) {
        return new InstanceIdentifierBuilderImpl().addWildNode(Item.of(container));
    }

    public static <C extends ChoiceIn<? extends DataRoot> & DataObject, T extends ChildOf<? super C>> InstanceIdentifierBuilder<T> builder(Class<C> caze, Class<T> container) {
        return new InstanceIdentifierBuilderImpl().addWildNode(Item.of(caze, container));
    }

    public static <N extends Identifiable<K> & ChildOf<? extends DataRoot>, K extends Identifier<N>> InstanceIdentifierBuilder<N> builder(Class<N> listItem, K listKey) {
        return new InstanceIdentifierBuilderImpl().addNode(IdentifiableItem.of(listItem, listKey));
    }

    public static <C extends ChoiceIn<? extends DataRoot> & DataObject, N extends Identifiable<K> & ChildOf<? super C>, K extends Identifier<N>> InstanceIdentifierBuilder<N> builder(Class<C> caze, Class<N> listItem, K listKey) {
        return new InstanceIdentifierBuilderImpl().addNode(IdentifiableItem.of(caze, listItem, listKey));
    }

    private static InstanceIdentifier<?> internalCreate(Iterable<PathArgument> pathArguments) {
        Iterator<PathArgument> it = Objects.requireNonNull(pathArguments, "pathArguments may not be null").iterator();
        HashCodeBuilder hashBuilder = new HashCodeBuilder();
        boolean wildcard = false;
        PathArgument arg = null;
        while (it.hasNext()) {
            arg = it.next();
            Preconditions.checkArgument((arg != null ? 1 : 0) != 0, (Object)"pathArguments may not contain null elements");
            hashBuilder.addArgument((Object)arg);
            if (!Identifiable.class.isAssignableFrom(arg.getType()) || arg instanceof IdentifiableItem) continue;
            wildcard = true;
        }
        Preconditions.checkArgument((arg != null ? 1 : 0) != 0, (Object)"pathArguments may not be empty");
        return InstanceIdentifier.trustedCreate(arg, pathArguments, hashBuilder.build(), wildcard);
    }

    public static InstanceIdentifier<?> create(Iterable<? extends PathArgument> pathArguments) {
        if (pathArguments instanceof ImmutableCollection) {
            Iterable<PathArgument> immutableArguments = pathArguments;
            return InstanceIdentifier.internalCreate(immutableArguments);
        }
        return InstanceIdentifier.internalCreate((Iterable<PathArgument>)ImmutableList.copyOf(pathArguments));
    }

    public static <T extends DataObject> InstanceIdentifier<T> create(Class<T> type) {
        return InstanceIdentifier.create((Iterable<? extends PathArgument>)ImmutableList.of(Item.of(type)));
    }

    public static <N extends Identifiable<K> & DataObject, K extends Identifier<N>> K keyOf(InstanceIdentifier<N> id) {
        Objects.requireNonNull(id);
        Preconditions.checkArgument((boolean)(id instanceof KeyedInstanceIdentifier), (String)"%s does not have a key", id);
        Object ret = ((KeyedInstanceIdentifier)id).getKey();
        return ret;
    }

    static <N extends DataObject> InstanceIdentifier<N> trustedCreate(PathArgument arg, Iterable<PathArgument> pathArguments, int hash, boolean wildcarded) {
        if (Identifiable.class.isAssignableFrom(arg.getType()) && !wildcarded) {
            Object key = null;
            if (arg instanceof IdentifiableItem) {
                key = ((IdentifiableItem)arg).getKey();
            } else {
                wildcarded = true;
            }
            return new KeyedInstanceIdentifier<DataObject, Object>(arg.getType(), pathArguments, wildcarded, hash, key);
        }
        return new InstanceIdentifier<DataObject>(arg.getType(), pathArguments, wildcarded, hash);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new InstanceIdentifierV3(this);
    }

    public static interface InstanceIdentifierBuilder<T extends DataObject>
    extends Builder<InstanceIdentifier<T>> {
        public <N extends ChildOf<? super T>> InstanceIdentifierBuilder<N> child(Class<N> var1);

        public <C extends ChoiceIn<? super T> & DataObject, N extends ChildOf<? super C>> InstanceIdentifierBuilder<N> child(Class<C> var1, Class<N> var2);

        public <N extends Identifiable<K> & ChildOf<? super T>, K extends Identifier<N>> InstanceIdentifierBuilder<N> child(Class<N> var1, K var2);

        public <C extends ChoiceIn<? super T> & DataObject, K extends Identifier<N>, N extends Identifiable<K> & ChildOf<? super C>> InstanceIdentifierBuilder<N> child(Class<C> var1, Class<N> var2, K var3);

        public <N extends DataObject & Augmentation<? super T>> InstanceIdentifierBuilder<N> augmentation(Class<N> var1);

        public InstanceIdentifier<T> build();
    }

    private static final class CaseIdentifiableItem<C extends ChoiceIn<?> & DataObject, T extends ChildOf<? super C> & Identifiable<K>, K extends Identifier<T>>
    extends IdentifiableItem<T, K> {
        private static final long serialVersionUID = 1L;
        private final Class<C> caseType;

        CaseIdentifiableItem(Class<C> caseType, Class<T> type, K key) {
            super(type, key);
            this.caseType = Objects.requireNonNull(caseType);
        }

        public Optional<Class<C>> getCaseType() {
            return Optional.of(this.caseType);
        }
    }

    private static final class CaseItem<C extends ChoiceIn<?> & DataObject, T extends ChildOf<? super C>>
    extends Item<T> {
        private static final long serialVersionUID = 1L;
        private final Class<C> caseType;

        CaseItem(Class<C> caseType, Class<T> type) {
            super(type);
            this.caseType = Objects.requireNonNull(caseType);
        }

        public Optional<Class<C>> getCaseType() {
            return Optional.of(this.caseType);
        }
    }

    public static class IdentifiableItem<I extends Identifiable<T> & DataObject, T extends Identifier<I>>
    extends AbstractPathArgument<I> {
        private static final long serialVersionUID = 1L;
        private final T key;

        IdentifiableItem(Class<I> type, T key) {
            super(type);
            this.key = (Identifier)Objects.requireNonNull(key, "Key may not be null.");
        }

        public static <T extends Identifiable<I> & DataObject, I extends Identifier<T>> IdentifiableItem<T, I> of(Class<T> type, I key) {
            return new IdentifiableItem<T, I>(type, key);
        }

        public static <C extends ChoiceIn<?> & DataObject, T extends ChildOf<? super C> & Identifiable<I>, I extends Identifier<T>> IdentifiableItem<T, I> of(Class<C> caseType, Class<T> type, I key) {
            return new CaseIdentifiableItem<C, T, I>(caseType, type, key);
        }

        @Override
        public final T getKey() {
            return this.key;
        }

        public String toString() {
            return this.getType().getName() + "[key=" + this.key + "]";
        }
    }

    public static class Item<T extends DataObject>
    extends AbstractPathArgument<T> {
        private static final long serialVersionUID = 1L;

        Item(Class<T> type) {
            super(type);
        }

        public static <T extends DataObject> Item<T> of(Class<T> type) {
            return new Item<T>(type);
        }

        public static <C extends ChoiceIn<?> & DataObject, T extends ChildOf<? super C>> Item<T> of(Class<C> caseType, Class<T> type) {
            return new CaseItem<C, T>(caseType, type);
        }

        public String toString() {
            return this.getType().getName();
        }
    }

    private static abstract class AbstractPathArgument<T extends DataObject>
    implements PathArgument,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Class<T> type;

        AbstractPathArgument(Class<T> type) {
            this.type = Objects.requireNonNull(type, "Type may not be null.");
        }

        public final Class<T> getType() {
            return this.type;
        }

        Object getKey() {
            return null;
        }

        public final int hashCode() {
            return Objects.hash(this.type, this.getCaseType(), this.getKey());
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AbstractPathArgument)) {
                return false;
            }
            AbstractPathArgument other = (AbstractPathArgument)obj;
            return this.type.equals(other.type) && Objects.equals(this.getKey(), other.getKey()) && this.getCaseType().equals(other.getCaseType());
        }

        @Override
        public final int compareTo(PathArgument arg) {
            int cmp = AbstractPathArgument.compareClasses(this.type, arg.getType());
            if (cmp != 0) {
                return cmp;
            }
            Optional<? extends Class<? extends DataObject>> caseType = this.getCaseType();
            if (!caseType.isPresent()) {
                return arg.getCaseType().isPresent() ? -1 : 1;
            }
            Optional<? extends Class<? extends DataObject>> argCaseType = this.getCaseType();
            return argCaseType.isPresent() ? AbstractPathArgument.compareClasses(caseType.get(), argCaseType.get()) : 1;
        }

        private static int compareClasses(Class<?> first, Class<?> second) {
            return first.getCanonicalName().compareTo(second.getCanonicalName());
        }
    }

    public static interface PathArgument
    extends Comparable<PathArgument> {
        public Class<? extends DataObject> getType();

        default public Optional<? extends Class<? extends DataObject>> getCaseType() {
            return Optional.empty();
        }
    }
}

