/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.openwebbeans.impl;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyWeavingHook
implements WeavingHook {
    private static Logger log = LoggerFactory.getLogger(ProxyWeavingHook.class);
    private Map<BundleWiring, Boolean> bundleMap = new WeakHashMap<BundleWiring, Boolean>();

    public void weave(WovenClass wovenClass) {
        BundleWiring wiring = wovenClass.getBundleWiring();
        Bundle bundle = wiring.getBundle();
        Boolean seen = this.bundleMap.get(wiring);
        if (seen != null) {
            return;
        }
        boolean requiresWeaving = false;
        if (ProxyWeavingHook.isBeanBundle(bundle) || ProxyWeavingHook.isExtension(bundle)) {
            log.debug("weaving {}", (Object)wovenClass.getClassName());
            wovenClass.getDynamicImports().add("org.apache.webbeans.*");
            requiresWeaving = true;
        }
        this.bundleMap.put(wiring, requiresWeaving);
    }

    private static boolean isBeanBundle(Bundle candidate) {
        List wires = ((BundleWiring)candidate.adapt(BundleWiring.class)).getRequiredWires("osgi.extender");
        for (BundleWire wire : wires) {
            String extender;
            Object object = wire.getCapability().getAttributes().get("osgi.extender");
            if (!(object instanceof String) || !(extender = (String)object).equals("osgi.cdi")) continue;
            return true;
        }
        return false;
    }

    private static boolean isExtension(Bundle candidate) {
        if (candidate.getSymbolicName().equals("osgi.cdi.extension")) {
            return true;
        }
        List wires = ((BundleWiring)candidate.adapt(BundleWiring.class)).getRequiredWires("osgi.cdi.extension");
        return !wires.isEmpty();
    }
}

