/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.openwebbeans;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.BeanArchiveService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.ops4j.pax.cdi.openwebbeans.impl.OpenWebBeansParser;
import org.ops4j.pax.cdi.spi.scan.BeanDescriptorParser;
import org.ops4j.pax.cdi.spi.scan.BeanScanner;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleScannerService
implements ScannerService {
    private static Logger log = LoggerFactory.getLogger(BundleScannerService.class);
    private BeanScanner scanner;
    private Bundle bundle;
    private Set<Class<?>> beanClasses;

    public void init(Object object) {
    }

    public void scan() {
        BeanArchiveService archiveService = WebBeansContext.getInstance().getBeanArchiveService();
        OpenWebBeansParser parser = new OpenWebBeansParser(archiveService);
        this.bundle = BundleUtils.getContextBundle((boolean)true);
        this.scanner = new BeanScanner(this.bundle, (BeanDescriptorParser)parser);
        this.scanner.scan();
    }

    public void release() {
        this.scanner = null;
        this.bundle = null;
        this.beanClasses = null;
    }

    public Set<URL> getBeanXmls() {
        return this.scanner.getBeanDescriptors();
    }

    public Set<Class<?>> getBeanClasses() {
        if (this.beanClasses == null) {
            this.beanClasses = new HashSet();
            for (String className : this.scanner.getBeanClasses()) {
                try {
                    Class klass = this.bundle.loadClass(className);
                    this.beanClasses.add(klass);
                }
                catch (ClassNotFoundException exc) {
                    log.debug("cannot load class " + className, (Throwable)exc);
                }
            }
        }
        return this.beanClasses;
    }

    public boolean isBDABeansXmlScanningEnabled() {
        return false;
    }

    public BDABeansXmlScanner getBDABeansXmlScanner() {
        return null;
    }
}

