/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.igp.link.attributes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.FlagIdentity;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.igp.link.attributes.IgpLinkAttributes;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class IgpLinkAttributesBuilder
implements Builder<IgpLinkAttributes> {
    private List<Class<? extends FlagIdentity>> _flag;
    private Long _metric;
    private String _name;
    Map<Class<? extends Augmentation<IgpLinkAttributes>>, Augmentation<IgpLinkAttributes>> augmentation = Collections.emptyMap();

    public IgpLinkAttributesBuilder() {
    }

    public IgpLinkAttributesBuilder(IgpLinkAttributes base) {
        Map aug;
        this._flag = base.getFlag();
        this._metric = base.getMetric();
        this._name = base.getName();
        if (base instanceof IgpLinkAttributesImpl) {
            IgpLinkAttributesImpl impl = (IgpLinkAttributesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<IgpLinkAttributes>>, Augmentation<IgpLinkAttributes>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IgpLinkAttributes>>, Augmentation<IgpLinkAttributes>>(aug);
        }
    }

    public List<Class<? extends FlagIdentity>> getFlag() {
        return this._flag;
    }

    public Long getMetric() {
        return this._metric;
    }

    public String getName() {
        return this._name;
    }

    public <E$$ extends Augmentation<IgpLinkAttributes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public IgpLinkAttributesBuilder setFlag(List<Class<? extends FlagIdentity>> values) {
        this._flag = values;
        return this;
    }

    private static void checkMetricRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..16777215]]", (long)value);
    }

    public IgpLinkAttributesBuilder setMetric(Long value) {
        if (value != null) {
            IgpLinkAttributesBuilder.checkMetricRange(value);
        }
        this._metric = value;
        return this;
    }

    public IgpLinkAttributesBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public IgpLinkAttributesBuilder addAugmentation(Class<? extends Augmentation<IgpLinkAttributes>> augmentationType, Augmentation<IgpLinkAttributes> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IgpLinkAttributes>>, Augmentation<IgpLinkAttributes>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public IgpLinkAttributesBuilder removeAugmentation(Class<? extends Augmentation<IgpLinkAttributes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public IgpLinkAttributes build() {
        return new IgpLinkAttributesImpl(this);
    }

    private static final class IgpLinkAttributesImpl
    implements IgpLinkAttributes {
        private final List<Class<? extends FlagIdentity>> _flag;
        private final Long _metric;
        private final String _name;
        private Map<Class<? extends Augmentation<IgpLinkAttributes>>, Augmentation<IgpLinkAttributes>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        IgpLinkAttributesImpl(IgpLinkAttributesBuilder base) {
            this._flag = base.getFlag();
            this._metric = base.getMetric();
            this._name = base.getName();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<IgpLinkAttributes> getImplementedInterface() {
            return IgpLinkAttributes.class;
        }

        @Override
        public List<Class<? extends FlagIdentity>> getFlag() {
            return this._flag;
        }

        @Override
        public Long getMetric() {
            return this._metric;
        }

        @Override
        public String getName() {
            return this._name;
        }

        public <E$$ extends Augmentation<IgpLinkAttributes>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._flag);
            result = 31 * result + Objects.hashCode(this._metric);
            result = 31 * result + Objects.hashCode(this._name);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!IgpLinkAttributes.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            IgpLinkAttributes other = (IgpLinkAttributes)obj;
            if (!Objects.equals(this._flag, other.getFlag())) {
                return false;
            }
            if (!Objects.equals(this._metric, other.getMetric())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                IgpLinkAttributesImpl otherImpl = (IgpLinkAttributesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<IgpLinkAttributes>>, Augmentation<IgpLinkAttributes>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"IgpLinkAttributes");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_flag", this._flag);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_metric", (Object)this._metric);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)this._name);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

