/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.node.attributes.SupportingNode;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.IgpEventType;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.IgpNodeEvent;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.L3UnicastIgpTopologyType;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.igp.node.attributes.IgpNodeAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.l3.unicast.igp.topology.type.L3UnicastIgpTopology;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class IgpNodeEventBuilder
implements Builder<IgpNodeEvent> {
    private IgpEventType _igpEventType;
    private IgpNodeAttributes _igpNodeAttributes;
    private L3UnicastIgpTopology _l3UnicastIgpTopology;
    private NodeId _nodeId;
    private List<SupportingNode> _supportingNode;
    private TopologyId _topologyRef;
    Map<Class<? extends Augmentation<IgpNodeEvent>>, Augmentation<IgpNodeEvent>> augmentation = Collections.emptyMap();

    public IgpNodeEventBuilder() {
    }

    public IgpNodeEventBuilder(NodeAttributes arg) {
        this._nodeId = arg.getNodeId();
        this._supportingNode = arg.getSupportingNode();
    }

    public IgpNodeEventBuilder(L3UnicastIgpTopologyType arg) {
        this._l3UnicastIgpTopology = arg.getL3UnicastIgpTopology();
    }

    public IgpNodeEventBuilder(org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.IgpNodeAttributes arg) {
        this._igpNodeAttributes = arg.getIgpNodeAttributes();
    }

    public IgpNodeEventBuilder(IgpNodeEvent base) {
        Map aug;
        this._igpEventType = base.getIgpEventType();
        this._igpNodeAttributes = base.getIgpNodeAttributes();
        this._l3UnicastIgpTopology = base.getL3UnicastIgpTopology();
        this._nodeId = base.getNodeId();
        this._supportingNode = base.getSupportingNode();
        this._topologyRef = base.getTopologyRef();
        if (base instanceof IgpNodeEventImpl) {
            IgpNodeEventImpl impl = (IgpNodeEventImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<IgpNodeEvent>>, Augmentation<IgpNodeEvent>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IgpNodeEvent>>, Augmentation<IgpNodeEvent>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeAttributes) {
            this._nodeId = ((NodeAttributes)arg).getNodeId();
            this._supportingNode = ((NodeAttributes)arg).getSupportingNode();
            isValidArg = true;
        }
        if (arg instanceof L3UnicastIgpTopologyType) {
            this._l3UnicastIgpTopology = ((L3UnicastIgpTopologyType)arg).getL3UnicastIgpTopology();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.IgpNodeAttributes) {
            this._igpNodeAttributes = ((org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.IgpNodeAttributes)arg).getIgpNodeAttributes();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeAttributes, org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.L3UnicastIgpTopologyType, org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.IgpNodeAttributes]");
    }

    public IgpEventType getIgpEventType() {
        return this._igpEventType;
    }

    public IgpNodeAttributes getIgpNodeAttributes() {
        return this._igpNodeAttributes;
    }

    public L3UnicastIgpTopology getL3UnicastIgpTopology() {
        return this._l3UnicastIgpTopology;
    }

    public NodeId getNodeId() {
        return this._nodeId;
    }

    public List<SupportingNode> getSupportingNode() {
        return this._supportingNode;
    }

    public TopologyId getTopologyRef() {
        return this._topologyRef;
    }

    public <E$$ extends Augmentation<IgpNodeEvent>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public IgpNodeEventBuilder setIgpEventType(IgpEventType value) {
        this._igpEventType = value;
        return this;
    }

    public IgpNodeEventBuilder setIgpNodeAttributes(IgpNodeAttributes value) {
        this._igpNodeAttributes = value;
        return this;
    }

    public IgpNodeEventBuilder setL3UnicastIgpTopology(L3UnicastIgpTopology value) {
        this._l3UnicastIgpTopology = value;
        return this;
    }

    public IgpNodeEventBuilder setNodeId(NodeId value) {
        this._nodeId = value;
        return this;
    }

    public IgpNodeEventBuilder setSupportingNode(List<SupportingNode> values) {
        this._supportingNode = values;
        return this;
    }

    public IgpNodeEventBuilder setTopologyRef(TopologyId value) {
        this._topologyRef = value;
        return this;
    }

    public IgpNodeEventBuilder addAugmentation(Class<? extends Augmentation<IgpNodeEvent>> augmentationType, Augmentation<IgpNodeEvent> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IgpNodeEvent>>, Augmentation<IgpNodeEvent>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public IgpNodeEventBuilder removeAugmentation(Class<? extends Augmentation<IgpNodeEvent>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public IgpNodeEvent build() {
        return new IgpNodeEventImpl(this);
    }

    private static final class IgpNodeEventImpl
    implements IgpNodeEvent {
        private final IgpEventType _igpEventType;
        private final IgpNodeAttributes _igpNodeAttributes;
        private final L3UnicastIgpTopology _l3UnicastIgpTopology;
        private final NodeId _nodeId;
        private final List<SupportingNode> _supportingNode;
        private final TopologyId _topologyRef;
        private Map<Class<? extends Augmentation<IgpNodeEvent>>, Augmentation<IgpNodeEvent>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        IgpNodeEventImpl(IgpNodeEventBuilder base) {
            this._igpEventType = base.getIgpEventType();
            this._igpNodeAttributes = base.getIgpNodeAttributes();
            this._l3UnicastIgpTopology = base.getL3UnicastIgpTopology();
            this._nodeId = base.getNodeId();
            this._supportingNode = base.getSupportingNode();
            this._topologyRef = base.getTopologyRef();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<IgpNodeEvent> getImplementedInterface() {
            return IgpNodeEvent.class;
        }

        @Override
        public IgpEventType getIgpEventType() {
            return this._igpEventType;
        }

        @Override
        public IgpNodeAttributes getIgpNodeAttributes() {
            return this._igpNodeAttributes;
        }

        @Override
        public L3UnicastIgpTopology getL3UnicastIgpTopology() {
            return this._l3UnicastIgpTopology;
        }

        public NodeId getNodeId() {
            return this._nodeId;
        }

        public List<SupportingNode> getSupportingNode() {
            return this._supportingNode;
        }

        @Override
        public TopologyId getTopologyRef() {
            return this._topologyRef;
        }

        public <E$$ extends Augmentation<IgpNodeEvent>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._igpEventType);
            result = 31 * result + Objects.hashCode(this._igpNodeAttributes);
            result = 31 * result + Objects.hashCode(this._l3UnicastIgpTopology);
            result = 31 * result + Objects.hashCode(this._nodeId);
            result = 31 * result + Objects.hashCode(this._supportingNode);
            result = 31 * result + Objects.hashCode(this._topologyRef);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!IgpNodeEvent.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            IgpNodeEvent other = (IgpNodeEvent)obj;
            if (!Objects.equals((Object)this._igpEventType, (Object)other.getIgpEventType())) {
                return false;
            }
            if (!Objects.equals(this._igpNodeAttributes, other.getIgpNodeAttributes())) {
                return false;
            }
            if (!Objects.equals(this._l3UnicastIgpTopology, other.getL3UnicastIgpTopology())) {
                return false;
            }
            if (!Objects.equals(this._nodeId, other.getNodeId())) {
                return false;
            }
            if (!Objects.equals(this._supportingNode, other.getSupportingNode())) {
                return false;
            }
            if (!Objects.equals(this._topologyRef, other.getTopologyRef())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                IgpNodeEventImpl otherImpl = (IgpNodeEventImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<IgpNodeEvent>>, Augmentation<IgpNodeEvent>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"IgpNodeEvent");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_igpEventType", (Object)((Object)this._igpEventType));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_igpNodeAttributes", (Object)this._igpNodeAttributes);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_l3UnicastIgpTopology", (Object)this._l3UnicastIgpTopology);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_nodeId", (Object)this._nodeId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_supportingNode", this._supportingNode);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_topologyRef", (Object)this._topologyRef);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

