/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import org.opendaylight.mdsal.binding.api.BindingService;
import org.opendaylight.mdsal.binding.api.MountPoint;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterLoader;
import org.opendaylight.mdsal.binding.dom.adapter.BindingToNormalizedNodeCodec;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class BindingMountPointAdapter
implements MountPoint {
    private final InstanceIdentifier<?> identifier;
    private final LoadingCache<Class<? extends BindingService>, Optional<BindingService>> services;

    public BindingMountPointAdapter(BindingToNormalizedNodeCodec codec, final DOMMountPoint domMountPoint) {
        this.identifier = codec.getCodecRegistry().fromYangInstanceIdentifier((YangInstanceIdentifier)domMountPoint.getIdentifier());
        this.services = CacheBuilder.newBuilder().build((CacheLoader)new BindingDOMAdapterLoader(codec){

            @Override
            protected DOMService getDelegate(Class<? extends DOMService> reqDeleg) {
                return domMountPoint.getService(reqDeleg).orElse(null);
            }
        });
    }

    public InstanceIdentifier<?> getIdentifier() {
        return this.identifier;
    }

    public <T extends BindingService> Optional<T> getService(Class<T> service) {
        return ((Optional)this.services.getUnchecked(service)).map(service::cast);
    }
}

