/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.opendaylight.mdsal.binding.api.RpcConsumerRegistry;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingLoadingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.BindingToNormalizedNodeCodec;
import org.opendaylight.mdsal.binding.dom.adapter.RpcServiceAdapter;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.yang.binding.RpcService;

public class BindingDOMRpcServiceAdapter
extends AbstractBindingLoadingAdapter<DOMRpcService, Class<? extends RpcService>, RpcServiceAdapter>
implements RpcConsumerRegistry {
    protected static final BindingDOMAdapterBuilder.Factory<RpcConsumerRegistry> BUILDER_FACTORY = () -> new Builder();

    public BindingDOMRpcServiceAdapter(DOMRpcService domService, BindingToNormalizedNodeCodec codec) {
        super(codec, domService);
    }

    public <T extends RpcService> T getRpcService(Class<T> rpcService) {
        Preconditions.checkArgument((rpcService != null ? 1 : 0) != 0, (Object)"Rpc Service needs to be specied.");
        return (T)((RpcServiceAdapter)this.getAdapter(rpcService)).getProxy();
    }

    @Override
    RpcServiceAdapter loadAdapter(Class<? extends RpcService> key) {
        Preconditions.checkArgument((boolean)BindingReflections.isBindingClass(key));
        Preconditions.checkArgument((boolean)key.isInterface(), (Object)"Supplied RPC service type must be interface.");
        return new RpcServiceAdapter(key, this.getCodec(), (DOMRpcService)this.getDelegate());
    }

    private static final class Builder
    extends BindingDOMAdapterBuilder<RpcConsumerRegistry> {
        private Builder() {
        }

        @Override
        protected RpcConsumerRegistry createInstance(BindingToNormalizedNodeCodec codec, ClassToInstanceMap<DOMService> delegates) {
            DOMRpcService domRpc = (DOMRpcService)delegates.getInstance(DOMRpcService.class);
            return new BindingDOMRpcServiceAdapter(domRpc, codec);
        }

        @Override
        public Set<? extends Class<? extends DOMService>> getRequiredDelegates() {
            return ImmutableSet.of(DOMRpcService.class);
        }
    }
}

