/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Optional;
import org.opendaylight.mdsal.binding.api.MountPoint;
import org.opendaylight.mdsal.binding.api.MountPointService;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingLoadingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMMountPointListenerAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingMountPointAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingToNormalizedNodeCodec;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class BindingDOMMountPointServiceAdapter
extends AbstractBindingLoadingAdapter<DOMMountPointService, DOMMountPoint, BindingMountPointAdapter>
implements MountPointService {
    public BindingDOMMountPointServiceAdapter(DOMMountPointService mountService, BindingToNormalizedNodeCodec codec) {
        super(codec, mountService);
    }

    public Optional<MountPoint> getMountPoint(InstanceIdentifier<?> mountPoint) {
        YangInstanceIdentifier domPath = this.getCodec().toYangInstanceIdentifierBlocking(mountPoint);
        Optional domMount = ((DOMMountPointService)this.getDelegate()).getMountPoint(domPath);
        return domMount.map(this::getAdapter);
    }

    public <T extends MountPointService.MountPointListener> ListenerRegistration<T> registerListener(InstanceIdentifier<?> path, T listener) {
        return new BindingDOMMountPointListenerAdapter<T>(listener, this.getCodec(), (DOMMountPointService)this.getDelegate());
    }

    @Override
    BindingMountPointAdapter loadAdapter(DOMMountPoint key) {
        return new BindingMountPointAdapter(this.getCodec(), key);
    }
}

