/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Collection;
import org.opendaylight.mdsal.binding.api.CursorAwareWriteTransaction;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeProducer;
import org.opendaylight.mdsal.binding.api.DataTreeProducerException;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMCursorAwareWriteTransactionAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingToNormalizedNodeCodec;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCursorAwareTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducer;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducerException;

class BindingDOMDataTreeProducerAdapter
extends AbstractBindingAdapter<DOMDataTreeProducer>
implements DataTreeProducer {
    BindingDOMDataTreeProducerAdapter(BindingToNormalizedNodeCodec codec, DOMDataTreeProducer delegate) {
        super(codec, delegate);
    }

    public CursorAwareWriteTransaction createTransaction(boolean isolated) {
        DOMDataTreeCursorAwareTransaction domTx = ((DOMDataTreeProducer)this.getDelegate()).createTransaction(isolated);
        return new BindingDOMCursorAwareWriteTransactionAdapter<DOMDataTreeCursorAwareTransaction>(domTx, this.getCodec());
    }

    static DataTreeProducer create(DOMDataTreeProducer domProducer, BindingToNormalizedNodeCodec codec) {
        return new BindingDOMDataTreeProducerAdapter(codec, domProducer);
    }

    public DataTreeProducer createProducer(Collection<DataTreeIdentifier<?>> subtrees) {
        Collection<DOMDataTreeIdentifier> domSubtrees = this.getCodec().toDOMDataTreeIdentifiers(subtrees);
        DOMDataTreeProducer domChildProducer = ((DOMDataTreeProducer)this.getDelegate()).createProducer(domSubtrees);
        return BindingDOMDataTreeProducerAdapter.create(domChildProducer, this.getCodec());
    }

    public void close() throws DataTreeProducerException {
        try {
            ((DOMDataTreeProducer)this.getDelegate()).close();
        }
        catch (DOMDataTreeProducerException e) {
            throw new DataTreeProducerException(e.getMessage(), (Throwable)e);
        }
    }
}

