/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.Beta;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.binding.api.ActionProviderService;
import org.opendaylight.mdsal.binding.api.ActionService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataTreeService;
import org.opendaylight.mdsal.binding.api.MountPointService;
import org.opendaylight.mdsal.binding.api.NotificationPublishService;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.api.RpcConsumerRegistry;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.dom.adapter.ActionProviderServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.ActionServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMDataBrokerAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMDataTreeServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMMountPointServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMNotificationPublishServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMNotificationServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMRpcProviderServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMRpcServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingToNormalizedNodeCodec;
import org.opendaylight.mdsal.binding.dom.adapter.spi.AdapterFactory;
import org.opendaylight.mdsal.dom.api.DOMActionProviderService;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeService;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMNotificationPublishService;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.yangtools.concepts.Immutable;

@Beta
@NonNullByDefault
public final class BindingAdapterFactory
implements AdapterFactory,
Immutable {
    private final BindingToNormalizedNodeCodec codec;

    public BindingAdapterFactory(BindingToNormalizedNodeCodec codec) {
        this.codec = Objects.requireNonNull(codec);
    }

    @Override
    public DataBroker createDataBroker(DOMDataBroker domService) {
        return new BindingDOMDataBrokerAdapter(domService, this.codec);
    }

    @Override
    public DataTreeService createDataTreeService(DOMDataTreeService domService) {
        return BindingDOMDataTreeServiceAdapter.create(domService, this.codec);
    }

    @Override
    public MountPointService createMountPointService(DOMMountPointService domService) {
        return new BindingDOMMountPointServiceAdapter(domService, this.codec);
    }

    @Override
    public NotificationService createNotificationService(DOMNotificationService domService) {
        return new BindingDOMNotificationServiceAdapter(domService, this.codec);
    }

    @Override
    public NotificationPublishService createNotificationPublishService(DOMNotificationPublishService domService) {
        return new BindingDOMNotificationPublishServiceAdapter(domService, this.codec);
    }

    @Override
    public RpcConsumerRegistry createRpcConsumerRegistry(DOMRpcService domService) {
        return new BindingDOMRpcServiceAdapter(domService, this.codec);
    }

    @Override
    public RpcProviderService createRpcProviderService(DOMRpcProviderService domService) {
        return new BindingDOMRpcProviderServiceAdapter(domService, this.codec);
    }

    @Override
    public ActionService createActionService(DOMActionService domService) {
        return new ActionServiceAdapter(this.codec, domService);
    }

    @Override
    public ActionProviderService createActionProviderService(DOMActionProviderService domService) {
        return new ActionProviderServiceAdapter(this.codec, domService);
    }
}

