/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.adapter.BindingToNormalizedNodeCodec;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadOperations;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

abstract class AbstractForwardedTransaction<T extends DOMDataTreeTransaction>
implements Delegator<T>,
Identifiable<Object> {
    private final @NonNull BindingToNormalizedNodeCodec codec;
    private final @NonNull T delegate;

    AbstractForwardedTransaction(T delegateTx, BindingToNormalizedNodeCodec codec) {
        this.delegate = (DOMDataTreeTransaction)Objects.requireNonNull(delegateTx, "Delegate must not be null");
        this.codec = Objects.requireNonNull(codec, "Codec must not be null");
    }

    public final Object getIdentifier() {
        return this.delegate.getIdentifier();
    }

    public final T getDelegate() {
        return this.delegate;
    }

    protected final <S extends DOMDataTreeTransaction> S getDelegateChecked(Class<S> txType) {
        Preconditions.checkState((boolean)txType.isInstance(this.delegate));
        return (S)((DOMDataTreeTransaction)txType.cast(this.delegate));
    }

    protected final BindingToNormalizedNodeCodec getCodec() {
        return this.codec;
    }

    protected final <D extends DataObject> @NonNull FluentFuture<Optional<D>> doRead(DOMDataTreeReadOperations readOps, LogicalDatastoreType store, InstanceIdentifier<D> path) {
        Preconditions.checkArgument((!path.isWildcarded() ? 1 : 0) != 0, (String)"Invalid read of wildcarded path %s", path);
        return readOps.read(store, this.codec.toYangInstanceIdentifierBlocking(path)).transform(this.codec.getCodecRegistry().deserializeFunction(path)::apply, MoreExecutors.directExecutor());
    }

    protected final @NonNull FluentFuture<Boolean> doExists(DOMDataTreeReadOperations readOps, LogicalDatastoreType store, InstanceIdentifier<?> path) {
        Preconditions.checkArgument((!path.isWildcarded() ? 1 : 0) != 0, (String)"Invalid exists of wildcarded path %s", path);
        return readOps.exists(store, this.codec.toYangInstanceIdentifierBlocking(path));
    }
}

