/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.URLResource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.osgi.framework.Bundle;

class WebAppBundleContext
extends WebAppContext {
    public WebAppBundleContext(String contextPath, final Bundle bundle, ClassLoader parent) {
        super(null, contextPath.substring(1), contextPath);
        this.setBaseResource(new BundleURLResource(bundle.getEntry("/")));
        this.setClassLoader(new ClassLoader(parent){

            @Override
            protected Class<?> findClass(String s) throws ClassNotFoundException {
                if (bundle.getState() == 32) {
                    try {
                        return bundle.loadClass(s);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                return super.findClass(s);
            }

            @Override
            protected URL findResource(String name) {
                URL url;
                if (bundle.getState() == 32 && (url = bundle.getResource(name)) != null) {
                    return url;
                }
                return super.findResource(name);
            }

            @Override
            protected Enumeration<URL> findResources(String name) throws IOException {
                Enumeration urls;
                if (bundle.getState() == 32 && (urls = bundle.getResources(name)) != null) {
                    return urls;
                }
                return super.findResources(name);
            }
        });
        this.setThrowUnavailableOnStartupException(true);
    }

    @Override
    public Resource newResource(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        return new BundleURLResource(url);
    }

    static class BundleURLResource
    extends URLResource {
        BundleURLResource(URL url) {
            super(url, null);
        }

        @Override
        public synchronized void close() {
            if (this._in != null) {
                this._in = null;
            }
            super.close();
        }

        @Override
        public Resource addPath(String path) throws MalformedURLException {
            if (path == null) {
                return null;
            }
            path = URIUtil.canonicalPath(path);
            URL url = new URL(URIUtil.addPaths(this._url.toExternalForm(), path));
            return new BundleURLResource(url);
        }

        @Override
        public File getFile() throws IOException {
            return null;
        }
    }
}

