/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.usertx.client;

import java.io.Serializable;
import java.util.Collection;
import java.util.EventListener;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.tm.TransactionManagerLocator;
import org.jboss.tm.usertx.UserTransactionProvider;
import org.jboss.tm.usertx.UserTransactionRegistry;
import org.jboss.tm.usertx.client.ServerVMClientUserTransactionFactory;

public class ServerVMClientUserTransaction
implements UserTransaction,
UserTransactionProvider,
Serializable,
Referenceable {
    private static final ThreadLocal<Boolean> isAvailables = new ThreadLocal();
    private static final ServerVMClientUserTransaction singleton = new ServerVMClientUserTransaction();
    private volatile TransactionManager tm;
    private volatile UserTransactionRegistry registry;
    private final Collection<UserTransactionStartedListener> listeners = new CopyOnWriteArrayList<UserTransactionStartedListener>();

    public static ServerVMClientUserTransaction getSingleton() {
        return singleton;
    }

    private ServerVMClientUserTransaction() {
        this(TransactionManagerLocator.locateTransactionManager(false));
    }

    public ServerVMClientUserTransaction(TransactionManager tm) {
        this.tm = tm;
    }

    public boolean isServer() {
        return this.tm != null;
    }

    public void registerTxStartedListener(UserTransactionStartedListener txStartedListener) {
        if (txStartedListener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        this.listeners.add(txStartedListener);
    }

    public void unregisterTxStartedListener(UserTransactionStartedListener txStartedListener) {
        if (txStartedListener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        this.listeners.remove(txStartedListener);
    }

    @Override
    public void setTransactionRegistry(UserTransactionRegistry registry) {
        this.registry = registry;
    }

    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    @Override
    public void begin() throws NotSupportedException, SystemException {
        this.testAvailability();
        this.tm.begin();
        UserTransactionRegistry registry = this.registry;
        if (registry != null) {
            registry.userTransactionStarted();
        }
        try {
            for (UserTransactionStartedListener listener : this.listeners) {
                listener.userTransactionStarted();
            }
        }
        catch (SystemException e) {
            this.rollback();
        }
    }

    @Override
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.testAvailability();
        this.tm.commit();
    }

    @Override
    public void rollback() throws SecurityException, IllegalStateException, SystemException {
        this.testAvailability();
        this.tm.rollback();
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.testAvailability();
        this.tm.setRollbackOnly();
    }

    @Override
    public int getStatus() throws SystemException {
        this.testAvailability();
        return this.tm.getStatus();
    }

    @Override
    public void setTransactionTimeout(int seconds) throws SystemException {
        this.testAvailability();
        this.tm.setTransactionTimeout(seconds);
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(ServerVMClientUserTransaction.class.getName(), ServerVMClientUserTransactionFactory.class.getCanonicalName(), null);
    }

    public static void setAvailability(boolean available) {
        isAvailables.set(available);
    }

    public static boolean isAvailable() {
        Boolean isAvailable = isAvailables.get();
        if (isAvailable == null) {
            return true;
        }
        return isAvailable;
    }

    private void testAvailability() {
        if (!ServerVMClientUserTransaction.isAvailable()) {
            throw new IllegalStateException("UserTransaction is not available within the scope of a bean or method annotated with @Transactional and a Transactional.TxType other than NOT_SUPPORTED or NEVER");
        }
    }

    @Deprecated
    public static interface UserTransactionStartedListener
    extends EventListener {
        public void userTransactionStarted() throws SystemException;
    }
}

