/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.tm.impl;

import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import org.ops4j.pax.transx.tm.NamedResource;
import org.ops4j.pax.transx.tm.Status;
import org.ops4j.pax.transx.tm.Transaction;
import org.ops4j.pax.transx.tm.TransactionManager;

public abstract class AbstractTransactionManagerWrapper<TM extends javax.transaction.TransactionManager>
implements TransactionManager {
    protected final TM tm;
    protected final WeakHashMap<javax.transaction.Transaction, TransactionWrapper> transactions = new WeakHashMap();

    public AbstractTransactionManagerWrapper(TM tm) {
        this.tm = tm;
    }

    public Transaction getTransaction() {
        try {
            javax.transaction.Transaction jtx = this.tm.getTransaction();
            if (jtx == null) {
                return null;
            }
            return this.transactions.computeIfAbsent(jtx, this::doCreateTransactionWrapper);
        }
        catch (SystemException e) {
            throw new RuntimeException("Unable to get transaction", e);
        }
    }

    public Transaction begin() throws Exception {
        this.tm.begin();
        this.disassociate();
        return this.getTransaction();
    }

    protected TransactionWrapper doCreateTransactionWrapper(javax.transaction.Transaction tx) {
        return new TransactionWrapper(tx);
    }

    void disassociate() {
    }

    void associate(Transaction tx) {
    }

    protected static Status toStatus(int status) {
        switch (status) {
            case 0: {
                return Status.ACTIVE;
            }
            case 1: {
                return Status.MARKED_ROLLBACK;
            }
            case 2: {
                return Status.PREPARED;
            }
            case 3: {
                return Status.COMMITTED;
            }
            case 4: {
                return Status.ROLLED_BACK;
            }
            case 7: {
                return Status.PREPARING;
            }
            case 8: {
                return Status.COMMITTING;
            }
            case 9: {
                return Status.ROLLING_BACK;
            }
        }
        return Status.NO_TRANSACTION;
    }

    protected class TransactionWrapper
    implements Transaction {
        final javax.transaction.Transaction transaction;
        boolean suspended;

        public TransactionWrapper(javax.transaction.Transaction transaction) {
            this.transaction = Objects.requireNonNull(transaction, "transaction should not be null");
            if (this.isActive()) {
                this.synchronization(null, st -> AbstractTransactionManagerWrapper.this.disassociate());
            }
        }

        protected javax.transaction.Transaction getTransaction() throws SystemException {
            return this.transaction;
        }

        public boolean isActive() {
            return this.getStatus() == Status.ACTIVE;
        }

        public void suspend() throws Exception {
            javax.transaction.Transaction tx = AbstractTransactionManagerWrapper.this.tm.suspend();
            if (tx != this.transaction) {
                throw new IllegalStateException();
            }
            AbstractTransactionManagerWrapper.this.disassociate();
        }

        public void resume() throws Exception {
            javax.transaction.Transaction tx = AbstractTransactionManagerWrapper.this.tm.getTransaction();
            if (tx != null) {
                throw new IllegalStateException();
            }
            AbstractTransactionManagerWrapper.this.tm.resume(this.getTransaction());
            AbstractTransactionManagerWrapper.this.associate(this);
        }

        public void commit() throws Exception {
            this.ensureAssociated();
            try {
                this.getTransaction().commit();
            }
            finally {
                AbstractTransactionManagerWrapper.this.disassociate();
            }
        }

        public void rollback() throws Exception {
            this.ensureAssociated();
            try {
                this.getTransaction().rollback();
            }
            finally {
                AbstractTransactionManagerWrapper.this.disassociate();
            }
        }

        public void setRollbackOnly() throws Exception {
            this.ensureAssociated();
            this.getTransaction().setRollbackOnly();
        }

        public Status getStatus() {
            try {
                if (this.suspended) {
                    return Status.SUSPENDED;
                }
                return AbstractTransactionManagerWrapper.toStatus(this.getTransaction().getStatus());
            }
            catch (SystemException e) {
                throw new RuntimeException("Exception caught while getting transaction status", e);
            }
        }

        public void enlistResource(NamedResource xares) throws Exception {
            this.ensureAssociated();
            this.getTransaction().enlistResource((XAResource)xares);
        }

        public void delistResource(NamedResource xares, int flags) throws Exception {
            this.ensureAssociated();
            this.getTransaction().delistResource((XAResource)xares, flags);
        }

        public void synchronization(final Runnable pre, final Consumer<Status> post) {
            this.ensureAssociated();
            try {
                this.getTransaction().registerSynchronization(new Synchronization(){

                    public void beforeCompletion() {
                        if (pre != null) {
                            pre.run();
                        }
                    }

                    public void afterCompletion(int status) {
                        if (post != null) {
                            post.accept(AbstractTransactionManagerWrapper.toStatus(status));
                        }
                    }
                });
            }
            catch (RollbackException e) {
                throw new IllegalStateException("Transaction is marked for rollback", e);
            }
            catch (SystemException e) {
                throw new RuntimeException("Exception caught while registering synchronization", e);
            }
        }

        private void ensureAssociated() {
            if (this.suspended) {
                throw new IllegalStateException("Transaction is suspended");
            }
        }
    }
}

