/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.runtime.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.AriesApplicationContext;
import org.apache.aries.application.management.ManagementException;
import org.apache.aries.application.management.UpdateException;
import org.apache.aries.application.management.spi.runtime.AriesApplicationContextManager;
import org.apache.aries.application.runtime.impl.ApplicationContextImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class ApplicationContextManagerImpl
implements AriesApplicationContextManager {
    private ConcurrentMap<AriesApplication, ApplicationContextImpl> _appToContextMap = new ConcurrentHashMap<AriesApplication, ApplicationContextImpl>();
    private BundleContext _bundleContext;

    public void setBundleContext(BundleContext b) {
        this._bundleContext = b;
    }

    public AriesApplicationContext getApplicationContext(AriesApplication app) throws BundleException, ManagementException {
        ApplicationContextImpl result;
        if (this._appToContextMap.containsKey(app)) {
            result = (ApplicationContextImpl)this._appToContextMap.get(app);
        } else {
            result = new ApplicationContextImpl(this._bundleContext, app);
            ApplicationContextImpl previous = this._appToContextMap.putIfAbsent(app, result);
            if (previous != null) {
                result = previous;
            }
        }
        return result;
    }

    public Set<AriesApplicationContext> getApplicationContexts() {
        HashSet<AriesApplicationContext> result = new HashSet<AriesApplicationContext>();
        for (Map.Entry entry : this._appToContextMap.entrySet()) {
            result.add((AriesApplicationContext)entry.getValue());
        }
        return result;
    }

    public void remove(AriesApplicationContext app) {
        Iterator it = this._appToContextMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ApplicationContextImpl potentialMatch = (ApplicationContextImpl)entry.getValue();
            if (potentialMatch != app) continue;
            it.remove();
            this.uninstall(potentialMatch);
            break;
        }
    }

    private void uninstall(ApplicationContextImpl app) {
        Set<Bundle> bundles = app.getApplicationContent();
        for (Bundle b : bundles) {
            try {
                b.uninstall();
            }
            catch (BundleException be) {}
        }
        app.setState(AriesApplicationContext.ApplicationState.UNINSTALLED);
    }

    public void close() {
        for (ApplicationContextImpl ctx : this._appToContextMap.values()) {
            this.uninstall(ctx);
        }
        this._appToContextMap.clear();
    }

    public AriesApplicationContext update(AriesApplication app, DeploymentMetadata oldMetadata) throws UpdateException {
        ApplicationContextImpl oldCtx = (ApplicationContextImpl)this._appToContextMap.get(app);
        if (oldCtx == null) {
            throw new IllegalArgumentException("AriesApplication " + app.getApplicationMetadata().getApplicationSymbolicName() + "/" + app.getApplicationMetadata().getApplicationVersion() + " cannot be updated because it is not installed");
        }
        this.uninstall(oldCtx);
        try {
            AriesApplicationContext newCtx = this.getApplicationContext(app);
            if (oldCtx.getApplicationState() == AriesApplicationContext.ApplicationState.ACTIVE) {
                newCtx.start();
            }
            return newCtx;
        }
        catch (BundleException e) {
            throw new UpdateException("Update failed: " + e.getMessage(), (Exception)((Object)e), false, null);
        }
        catch (ManagementException e) {
            throw new UpdateException("Update failed: " + e.getMessage(), (Exception)((Object)e), false, null);
        }
    }
}

