/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.runtime.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.aries.application.DeploymentContent;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.AriesApplicationContext;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.ManagementException;
import org.apache.aries.application.management.spi.resolve.AriesApplicationResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;

public class ApplicationContextImpl
implements AriesApplicationContext {
    private AriesApplication _application;
    private Map<BundleInfo, Bundle> _bundles;
    private AriesApplicationContext.ApplicationState _state;
    private BundleContext _bundleContext;

    public ApplicationContextImpl(BundleContext b, AriesApplication app) throws BundleException, ManagementException {
        this._bundleContext = b;
        this._application = app;
        this._bundles = new HashMap<BundleInfo, Bundle>();
        DeploymentMetadata meta = this._application.getDeploymentMetadata();
        AriesApplicationResolver resolver = null;
        PackageAdmin packageAdmin = null;
        ServiceReference resolverRef = b.getServiceReference(AriesApplicationResolver.class.getName());
        ServiceReference packageAdminRef = b.getServiceReference(PackageAdmin.class.getName());
        try {
            resolver = this.getService(resolverRef, AriesApplicationResolver.class);
            packageAdmin = this.getService(packageAdminRef, PackageAdmin.class);
            ArrayList bundlesToInstall = new ArrayList(meta.getApplicationDeploymentContents());
            bundlesToInstall.addAll(meta.getApplicationProvisionBundles());
            bundlesToInstall.addAll(meta.getDeployedUseBundle());
            for (DeploymentContent content : bundlesToInstall) {
                Version bundleVersion;
                String bundleSymbolicName = content.getContentName();
                if (this.findBundleInFramework(packageAdmin, bundleSymbolicName, bundleVersion = content.getExactVersion()) != null) continue;
                BundleInfo bundleInfo = this.findBundleInfoInApplication(bundleSymbolicName, bundleVersion);
                if (bundleInfo == null) {
                    bundleInfo = this.findBundleInfoUsingResolver(resolver, bundleSymbolicName, bundleVersion);
                }
                if (bundleInfo == null) {
                    throw new ManagementException("Cound not find bundles: " + bundleSymbolicName + "_" + bundleVersion);
                }
                Bundle bundle = this._bundleContext.installBundle(bundleInfo.getLocation());
                this._bundles.put(bundleInfo, bundle);
            }
        }
        catch (BundleException be) {
            for (Bundle bundle : this._bundles.values()) {
                bundle.uninstall();
            }
            this._bundles.clear();
            throw be;
        }
        finally {
            if (resolver != null) {
                b.ungetService(resolverRef);
            }
            if (packageAdmin != null) {
                b.ungetService(packageAdminRef);
            }
        }
        this._state = AriesApplicationContext.ApplicationState.INSTALLED;
    }

    private <T> T getService(ServiceReference ref, Class<T> type) throws ManagementException {
        Object service = null;
        if (ref != null) {
            service = this._bundleContext.getService(ref);
        }
        if (service == null) {
            throw new ManagementException((Exception)new ServiceException(type.getName(), 1));
        }
        return type.cast(service);
    }

    private Bundle findBundleInFramework(PackageAdmin admin, String symbolicName, Version version) {
        String exactVersion = "[" + version + "," + version + "]";
        Bundle[] bundles = admin.getBundles(symbolicName, exactVersion);
        if (bundles != null && bundles.length == 1) {
            return bundles[0];
        }
        return null;
    }

    private BundleInfo findBundleInfoInApplication(String symbolicName, Version version) {
        for (BundleInfo info : this._application.getBundleInfo()) {
            if (!info.getSymbolicName().equals(symbolicName) || !info.getVersion().equals((Object)version)) continue;
            return info;
        }
        return null;
    }

    private BundleInfo findBundleInfoUsingResolver(AriesApplicationResolver resolver, String symbolicName, Version version) {
        return resolver.getBundleInfo(symbolicName, version);
    }

    public AriesApplication getApplication() {
        return this._application;
    }

    public Set<Bundle> getApplicationContent() {
        HashSet<Bundle> result = new HashSet<Bundle>();
        for (Map.Entry<BundleInfo, Bundle> entry : this._bundles.entrySet()) {
            result.add(entry.getValue());
        }
        return result;
    }

    public AriesApplicationContext.ApplicationState getApplicationState() {
        return this._state;
    }

    public void start() throws BundleException {
        this._state = AriesApplicationContext.ApplicationState.STARTING;
        ArrayList<Bundle> bundlesWeStarted = new ArrayList<Bundle>();
        try {
            for (Bundle b : this._bundles.values()) {
                if (b.getState() == 32) continue;
                b.start(2);
                bundlesWeStarted.add(b);
            }
        }
        catch (BundleException be) {
            for (Bundle b : bundlesWeStarted) {
                try {
                    b.stop();
                }
                catch (BundleException be2) {}
            }
            this._state = AriesApplicationContext.ApplicationState.INSTALLED;
            throw be;
        }
        this._state = AriesApplicationContext.ApplicationState.ACTIVE;
    }

    public void stop() throws BundleException {
        for (Map.Entry<BundleInfo, Bundle> entry : this._bundles.entrySet()) {
            Bundle b = entry.getValue();
            b.stop();
        }
        this._state = AriesApplicationContext.ApplicationState.RESOLVED;
    }

    public void setState(AriesApplicationContext.ApplicationState state) {
        this._state = state;
    }
}

