/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.afn.safi.rev130704;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum AddressFamily implements Enumeration
{
    IpV4(1, "ipV4"),
    IpV6(2, "ipV6"),
    Nsap(3, "nsap"),
    Hdlc(4, "hdlc"),
    Bbn1822(5, "bbn1822"),
    All802(6, "all802"),
    E163(7, "e163"),
    E164(8, "e164"),
    F69(9, "f69"),
    X121(10, "x121"),
    Ipx(11, "ipx"),
    Appletalk(12, "appletalk"),
    DecnetIV(13, "decnetIV"),
    BanyanVines(14, "banyanVines"),
    E164withNsap(15, "e164withNsap"),
    Dns(16, "dns"),
    DistinguishedName(17, "distinguishedName"),
    AsNumber(18, "asNumber"),
    XtpOverIpv4(19, "xtpOverIpv4"),
    XtpOverIpv6(20, "xtpOverIpv6"),
    XtpNativeModeXTP(21, "xtpNativeModeXTP"),
    FibreChannelWWPN(22, "fibreChannelWWPN"),
    FibreChannelWWNN(23, "fibreChannelWWNN"),
    Gwid(24, "gwid"),
    L2vpn(25, "l2vpn"),
    MplsTpSectionEndpointIdentifier(26, "mplsTpSectionEndpointIdentifier"),
    MplsTpLspEndpointIdentifier(27, "mplsTpLspEndpointIdentifier"),
    MplsTpPseudowireEndpointIdentifier(28, "mplsTpPseudowireEndpointIdentifier"),
    EigrpCommonServiceFamily(16384, "eigrpCommonServiceFamily"),
    EigrpIpv4ServiceFamily(16385, "eigrpIpv4ServiceFamily"),
    EigrpIpv6ServiceFamily(16386, "eigrpIpv6ServiceFamily"),
    LispCanonicalAddressFormat(16387, "lispCanonicalAddressFormat"),
    BgpLs(16388, "bgpLs"),
    _48BitMac(16389, "48BitMac"),
    _64BitMac(16390, "64BitMac");

    private static final Map<String, AddressFamily> NAME_MAP;
    private static final Map<Integer, AddressFamily> VALUE_MAP;
    private final String name;
    private final int value;

    private AddressFamily(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static Optional<AddressFamily> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    public static AddressFamily forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }

    static {
        ImmutableMap.Builder nb = ImmutableMap.builder();
        ImmutableMap.Builder vb = ImmutableMap.builder();
        for (AddressFamily enumItem : AddressFamily.values()) {
            vb.put((Object)enumItem.value, (Object)enumItem);
            nb.put((Object)enumItem.name, (Object)enumItem);
        }
        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }
}

