/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.yang.library;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.ModulesState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.ModulesStateBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.RevisionUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.Module;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.ModuleBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.module.Submodule;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.module.SubmoduleBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangIdentifier;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaServiceToMdsalWriter
implements SchemaContextListener,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaServiceToMdsalWriter.class);
    private static final InstanceIdentifier<ModulesState> MODULES_STATE_INSTANCE_IDENTIFIER = InstanceIdentifier.create(ModulesState.class);
    private final DOMSchemaService schemaService;
    private final AtomicInteger moduleSetId;
    private final DataBroker dataBroker;

    public SchemaServiceToMdsalWriter(DOMSchemaService schemaService, DataBroker dataBroker) {
        this.schemaService = schemaService;
        this.dataBroker = dataBroker;
        this.moduleSetId = new AtomicInteger(0);
    }

    @Override
    public void close() {
    }

    public void start() {
        this.schemaService.registerSchemaContextListener((SchemaContextListener)this);
    }

    public void onGlobalContextUpdated(SchemaContext context) {
        ModulesState newModuleState = this.createModuleStateFromModules(context.getModules());
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        tx.put(LogicalDatastoreType.OPERATIONAL, MODULES_STATE_INSTANCE_IDENTIFIER, (DataObject)newModuleState);
        LOG.debug("Trying to write new module-state: {}", (Object)newModuleState);
        tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.debug("Modules state updated successfully");
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("Failed to update modules state", throwable);
            }
        }, MoreExecutors.directExecutor());
    }

    private ModulesState createModuleStateFromModules(Set<Module> modules) {
        return new ModulesStateBuilder().setModule(modules.stream().map(this::createModuleEntryFromModule).collect(Collectors.toList())).setModuleSetId(String.valueOf(this.moduleSetId.getAndIncrement())).build();
    }

    private org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.Module createModuleEntryFromModule(Module module) {
        return new ModuleBuilder().setName(new YangIdentifier(module.getName())).setRevision(RevisionUtils.fromYangCommon((Optional)module.getQNameModule().getRevision())).setNamespace(new Uri(module.getNamespace().toString())).setConformanceType(Module.ConformanceType.Implement).setSubmodule(SchemaServiceToMdsalWriter.createSubmodulesForModule(module)).build();
    }

    private static List<Submodule> createSubmodulesForModule(Module module) {
        return module.getSubmodules().stream().map(subModule -> new SubmoduleBuilder().setName(new YangIdentifier(subModule.getName())).setRevision(RevisionUtils.fromYangCommon((Optional)subModule.getQNameModule().getRevision())).build()).collect(Collectors.toList());
    }
}

