/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core.spi.data;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadWriteTransaction;
import org.opendaylight.controller.sal.core.spi.data.SnapshotBackedWriteTransaction;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class SnapshotBackedReadWriteTransaction<T>
extends SnapshotBackedWriteTransaction<T>
implements DOMStoreReadWriteTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotBackedReadWriteTransaction.class);

    SnapshotBackedReadWriteTransaction(T identifier, boolean debug, DataTreeSnapshot snapshot, SnapshotBackedWriteTransaction.TransactionReadyPrototype<T> readyImpl) {
        super(identifier, debug, snapshot, readyImpl);
    }

    @Override
    public CheckedFuture<Optional<NormalizedNode<?, ?>>, ReadFailedException> read(YangInstanceIdentifier path) {
        Optional<NormalizedNode<?, ?>> result;
        LOG.debug("Tx: {} Read: {}", this.getIdentifier(), (Object)path);
        Preconditions.checkNotNull((Object)path, (Object)"Path must not be null.");
        try {
            result = this.readSnapshotNode(path);
        }
        catch (RuntimeException e) {
            LOG.error("Tx: {} Failed Read of {}", new Object[]{this.getIdentifier(), path, e});
            return Futures.immediateFailedCheckedFuture((Exception)((Object)new ReadFailedException("Read failed", (Throwable)e, new RpcError[0])));
        }
        if (result == null) {
            return Futures.immediateFailedCheckedFuture((Exception)((Object)new ReadFailedException("Transaction is closed", new RpcError[0])));
        }
        return Futures.immediateCheckedFuture(result);
    }

    @Override
    public CheckedFuture<Boolean, ReadFailedException> exists(YangInstanceIdentifier path) {
        try {
            return Futures.immediateCheckedFuture((Object)((Optional)this.read(path).checkedGet()).isPresent());
        }
        catch (ReadFailedException e) {
            return Futures.immediateFailedCheckedFuture((Exception)((Object)e));
        }
    }
}

