/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core.spi.data;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.sal.core.spi.data.AbstractDOMStoreTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadTransaction;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class SnapshotBackedReadTransaction<T>
extends AbstractDOMStoreTransaction<T>
implements DOMStoreReadTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotBackedReadTransaction.class);
    private static final AtomicReferenceFieldUpdater<SnapshotBackedReadTransaction, DataTreeSnapshot> SNAPSHOT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SnapshotBackedReadTransaction.class, DataTreeSnapshot.class, "stableSnapshot");
    private TransactionClosePrototype<T> closeImpl;
    private volatile DataTreeSnapshot stableSnapshot;

    SnapshotBackedReadTransaction(T identifier, boolean debug, DataTreeSnapshot snapshot, TransactionClosePrototype<T> closeImpl) {
        super(identifier, debug);
        this.stableSnapshot = (DataTreeSnapshot)Preconditions.checkNotNull((Object)snapshot);
        this.closeImpl = closeImpl;
        LOG.debug("ReadOnly Tx: {} allocated with snapshot {}", identifier, (Object)snapshot);
    }

    @Override
    public void close() {
        DataTreeSnapshot prev = SNAPSHOT_UPDATER.getAndSet(this, null);
        if (prev == null) {
            LOG.debug("Store transaction: {} : previously closed", this.getIdentifier());
            return;
        }
        LOG.debug("Store transaction: {} : Closed", this.getIdentifier());
        if (this.closeImpl != null) {
            this.closeImpl.transactionClosed(this);
            this.closeImpl = null;
        }
    }

    @Override
    public CheckedFuture<com.google.common.base.Optional<NormalizedNode<?, ?>>, ReadFailedException> read(YangInstanceIdentifier path) {
        LOG.debug("Tx: {} Read: {}", this.getIdentifier(), (Object)path);
        Preconditions.checkNotNull((Object)path, (Object)"Path must not be null.");
        DataTreeSnapshot snapshot = this.stableSnapshot;
        if (snapshot == null) {
            return Futures.immediateFailedCheckedFuture((Exception)new ReadFailedException("Transaction is closed", new RpcError[0]));
        }
        try {
            return Futures.immediateCheckedFuture((Object)com.google.common.base.Optional.fromJavaUtil((Optional)snapshot.readNode(path)));
        }
        catch (RuntimeException e) {
            LOG.error("Tx: {} Failed Read of {}", new Object[]{this.getIdentifier(), path, e});
            return Futures.immediateFailedCheckedFuture((Exception)new ReadFailedException("Read failed", (Throwable)e, new RpcError[0]));
        }
    }

    @Override
    public CheckedFuture<Boolean, ReadFailedException> exists(YangInstanceIdentifier path) {
        LOG.debug("Tx: {} Exists: {}", this.getIdentifier(), (Object)path);
        Preconditions.checkNotNull((Object)path, (Object)"Path must not be null.");
        try {
            return Futures.immediateCheckedFuture((Object)((com.google.common.base.Optional)this.read(path).checkedGet()).isPresent());
        }
        catch (ReadFailedException e) {
            return Futures.immediateFailedCheckedFuture((Exception)((Object)e));
        }
    }

    public static interface TransactionClosePrototype<T> {
        public void transactionClosed(SnapshotBackedReadTransaction<T> var1);
    }
}

