/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core.spi.data;

import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.controller.md.sal.dom.spi.AbstractDOMDataTreeChangeListenerRegistration;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreTreeChangePublisher;
import org.opendaylight.mdsal.dom.spi.AbstractRegistrationTree;
import org.opendaylight.mdsal.dom.spi.RegistrationTreeNode;
import org.opendaylight.mdsal.dom.spi.RegistrationTreeSnapshot;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDOMStoreTreeChangePublisher
extends AbstractRegistrationTree<AbstractDOMDataTreeChangeListenerRegistration<?>>
implements DOMStoreTreeChangePublisher {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDOMStoreTreeChangePublisher.class);

    protected abstract void notifyListeners(@NonNull Collection<AbstractDOMDataTreeChangeListenerRegistration<?>> var1, @NonNull YangInstanceIdentifier var2, @NonNull DataTreeCandidateNode var3);

    protected abstract void registrationRemoved(@NonNull AbstractDOMDataTreeChangeListenerRegistration<?> var1);

    protected final void processCandidateTree(@NonNull DataTreeCandidate candidate) {
        DataTreeCandidateNode node = candidate.getRootNode();
        if (node.getModificationType() == ModificationType.UNMODIFIED) {
            LOG.debug("Skipping unmodified candidate {}", (Object)candidate);
            return;
        }
        try (RegistrationTreeSnapshot snapshot = this.takeSnapshot();){
            this.lookupAndNotify(candidate.getRootPath().getPathArguments(), 0, snapshot.getRootNode(), candidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <L extends DOMDataTreeChangeListener> AbstractDOMDataTreeChangeListenerRegistration<L> registerTreeChangeListener(YangInstanceIdentifier treeId, L listener) {
        this.takeLock();
        try {
            final RegistrationTreeNode node = this.findNodeFor(treeId.getPathArguments());
            AbstractDOMDataTreeChangeListenerRegistration reg = new AbstractDOMDataTreeChangeListenerRegistration<L>(listener){

                protected void removeRegistration() {
                    AbstractDOMStoreTreeChangePublisher.this.removeRegistration(node, (Object)this);
                    AbstractDOMStoreTreeChangePublisher.this.registrationRemoved(this);
                }
            };
            this.addRegistration(node, (Object)reg);
            AbstractDOMDataTreeChangeListenerRegistration abstractDOMDataTreeChangeListenerRegistration = reg;
            return abstractDOMDataTreeChangeListenerRegistration;
        }
        finally {
            this.releaseLock();
        }
    }

    private void lookupAndNotify(List<YangInstanceIdentifier.PathArgument> args, int offset, RegistrationTreeNode<AbstractDOMDataTreeChangeListenerRegistration<?>> node, DataTreeCandidate candidate) {
        if (args.size() != offset) {
            YangInstanceIdentifier.PathArgument arg = args.get(offset);
            RegistrationTreeNode exactChild = node.getExactChild(arg);
            if (exactChild != null) {
                this.lookupAndNotify(args, offset + 1, exactChild, candidate);
            }
            for (RegistrationTreeNode c : node.getInexactChildren(arg)) {
                this.lookupAndNotify(args, offset + 1, c, candidate);
            }
        } else {
            this.notifyNode(candidate.getRootPath(), node, candidate.getRootNode());
        }
    }

    private void notifyNode(YangInstanceIdentifier path, RegistrationTreeNode<AbstractDOMDataTreeChangeListenerRegistration<?>> regNode, DataTreeCandidateNode candNode) {
        if (candNode.getModificationType() == ModificationType.UNMODIFIED) {
            LOG.debug("Skipping unmodified candidate {}", (Object)path);
            return;
        }
        Collection regs = regNode.getRegistrations();
        if (!regs.isEmpty()) {
            this.notifyListeners(regs, path, candNode);
        }
        for (DataTreeCandidateNode candChild : candNode.getChildNodes()) {
            if (candChild.getModificationType() == ModificationType.UNMODIFIED) continue;
            RegistrationTreeNode regChild = regNode.getExactChild(candChild.getIdentifier());
            if (regChild != null) {
                this.notifyNode(path.node(candChild.getIdentifier()), regChild, candChild);
            }
            for (RegistrationTreeNode rc : regNode.getInexactChildren(candChild.getIdentifier())) {
                this.notifyNode(path.node(candChild.getIdentifier()), rc, candChild);
            }
        }
    }
}

